<?php

namespace App\Http\Controllers;

use App\Http\Controllers\Controller;
use App\Models\Banner;
use App\Models\Post;

class ClientController extends Controller
{

    public function home()
    {
        $posts = Post::orderBy('id', 'desc')->get();
        $banner = Banner::orderBy('id', 'desc')->get();
        return view('site.home', compact('posts', 'banner'));
    }

    public function noticias()
    {
        $posts = Post::orderBy('id', 'desc')->limit(3)->get();
        return view('site.noticias', compact('posts'));
    }

    public function noticia_view($nome_noticia)
    {
        //Pesquisa por nome da noticia.
        $nome_noticia =  strtolower(str_replace('-', ' ', $nome_noticia));
        $query = Post::select('*')->orderBy('id', 'desc');
        $query->orWhere('title', 'like', '%' . $nome_noticia . '%');
        $posts = $query->get();
        //Pesquisa a noticia encontrada.
        $noticia = Post::where('id', $posts[0]->id)->first();
        $noticia->contagem = $noticia->contagem + 1;
        $noticia->save();
        // $noticia = Post::where('id', $id)->first();
        return view('site.noticia_view', compact('noticia'));
    }
}
