<?php

namespace App\Http\Controllers;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Mail;
use Throwable;

class EmailController extends Controller
{
    public function contatoEmail(Request $request)
    {
        $params = $request->all();
        // dd($params);

        //Validação telefone (11) 99999-9999 // 15 caracteres
        if (strlen($request->telefone) < 15) {
            // dd(strlen($request->telefone));
            $request->session()->flash('error', "Telefone incorreto. Infelizmente não foi possivel enviar seu e-mail. Tente novamente com um telefone válido.");
            return redirect()->back();
        }

        try {
            Mail::send('mails.contato', $params, function ($message) use ($params) {
                $message->from('faleconosco@chacarasantoantoniosp.org.br', 'Contato Site');
                $message->to('faleconosco@chacarasantoantoniosp.org.br', 'Usuario');
                $message->subject('Mensagem via Formulário de Contato');
                $message->priority(3);
            });
            $request->session()->flash('status', 'Seu e-mail foi enviado com sucesso!');
            return redirect()->back();
        } catch (Throwable $e) {
            // dd($e);
            $request->session()->flash('error', "Não foi possivel enviar. Tente novamente mais tarde.");
            return redirect()->back();
        }
    }
}
