@extends('layouts.app')

@section('titlepage', 'Administradores')

@section('content')
    <div class="content-admin">
        @component('components.admin.nav')
        @endcomponent
        <div class="content card">
            <div class="card-header total">
                <span class="total">
                    <h1 class=" ">Usuários</h1>
                    <h1 style="margin: 0 2rem">
                        <a class="btn btn_custom" data-toggle="collapse" href="#openNewPost" role="button"
                            aria-expanded="false" aria-controls="openNewPost">Adicionar
                            Usuário</a>
                    </h1>
                </span>
                <h1>
                    <span>
                        Total: {{ $users->total() }}
                    </span>
                </h1>
            </div>

            <div class="collapse" id="openNewPost">
                <div class="card card-body">
                    <form action="{{ route('admin_add_user') }}" method="POST" enctype="multipart/form-data">
                        @csrf

                        <div class="form-group">
                            <label for="name">Nome</label>
                            <input required type="text" name="name" id="name" class="form-control"
                                maxlength="80">
                        </div>
                        <div class="form-group">
                            <label for="email">Email</label>
                            <input required type="text" name="email" id="email" class="form-control"
                                onblur="valida()">
                            <div class="alert alert-danger email-validation hide-self">
                                Digite um e-mail valido
                            </div>
                        </div>

                        <div class="form-group">
                            <label for="level">Tipo</label>
                            <select required name="level" id="level" class="form-control">
                                <option selected disabled>Selecione o Tipo </option>
                                <option value="1">Admin</option>
                                <option value="0">Sem Tipo</option>
                            </select>
                        </div>

                        <div class="form-group">
                            <button type="submit" class="btn btn_custom">Salvar Usuario</button>
                            <button type="reset" class="btn btn_custom2">Limpar Dados</button>
                            <a class="btn btn-danger" data-toggle="collapse" href="#openNewPost" role="button"
                                aria-expanded="false" aria-controls="openNewPost">Cancelar</a>
                        </div>
                    </form>
                </div>
            </div>

            <div class="card-body items-administradores-admin">
                <div class="header">
                    <div class="col1">
                        <h5>Nome</h5>
                    </div>
                    <div class="col2">
                        <h5>Email</h5>
                    </div>
                    <div class="col3">
                        <h5>Tipo</h5>
                    </div>
                    <div class="col4">
                        <h5>Ações</h5>
                    </div>
                </div>
                <div class="content">
                    @if (count($users) == 0)
                        <div class="item">
                            <h3 class="py-2 mb-0" style="text-align: center; width: 100%">Não há fotos cadastradas.
                            </h3>
                        </div>
                    @endif

                    @foreach ($users as $user)
                        <div class="item">
                            <div class="col1">
                                <p>{{ $user->name }}</p>
                            </div>
                            <div class="col2">
                                <p>{{ $user->email }}</p>
                            </div>
                            <div class="col3">
                                <p>{{ $user->tipo }}</p>
                            </div>
                            <div class="col4">
                                <div class="actions">
                                    <div class="dropleft">
                                        <button class="btn btn-secondary dropdown-toggle" type="button"
                                            id="dropdownMenuButton" data-toggle="dropdown" aria-haspopup="true"
                                            aria-expanded="false">
                                            <i class="fas fa-bars"></i>
                                        </button>
                                        <div class="dropdown-menu" aria-labelledby="dropdownMenuButton">

                                            @if ($user->level == 0)
                                                <form action="{{ route('admin_add') }}" method="POST"
                                                    onsubmit="return confirm('Tem certeza que deseja tornar User?')">
                                                    @csrf
                                                    <input type="hidden" name="id" value="{{ $user->id }}">
                                                    <button type="submit" class="btn btn_custom">Tornar
                                                        User</button>
                                                </form>
                                            @elseif($user->level == 10 and $user->id != Auth::user()->id)
                                                <form action="{{ route('admin_remove') }}" method="POST"
                                                    onsubmit="return confirm('Tem certeza que deseja remover Administrador?')">
                                                    @csrf
                                                    <input type="hidden" name="id" value="{{ $user->id }}">
                                                    <button type="submit" class="btn btn_custom">Remover Admin</button>
                                                </form>
                                            @elseif($user->id == Auth::user()->id)
                                                <form
                                                    onsubmit="return confirm('Tem certeza que deseja remover Administrador?')">
                                                    <button disabled="disabled" class="btn btn_custom">Remover
                                                        Admin</button>
                                                </form>
                                            @endif

                                            @if ($user->id == Auth::user()->id)
                                                <form onsubmit="return confirm('Tem certeza que deseja remover Usuário?')">
                                                    @csrf
                                                    <button disabled class="btn btn-danger"><i
                                                            class="fas fa-trash"></i></button>
                                                </form>
                                            @else
                                                <a href="" data-toggle="modal" style="padding:0 2px 4px 2px;"
                                                    data-target="#alterarSenha" onclick="params({{ $user->id }})">
                                                    <button style="width: 100%; background-color: #555555; color: #fff"
                                                        class="btn">Alterar Senha
                                                    </button>
                                                </a>
                                                <form action="{{ route('user_delete') }}" method="POST"
                                                    onsubmit="return confirm('Tem certeza que deseja remover Usuário?')">
                                                    @csrf
                                                    <input type="hidden" name="id" value="{{ $user->id }}">
                                                    <button type="submit" class="btn btn-danger"><i
                                                            class="fas fa-trash"></i></button>
                                                </form>
                                            @endif
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    @endforeach
                </div>
                <div class="paginacao">
                    <h1> {{ $users }}</h1>
                </div>
            </div>
        </div>
    </div>

    @component('components.popup_automatico')
    @endcomponent

@endsection

@push('footerData')
    <script>
        $("#formulario").submit(function(event) {
            if (!isEmail($("#email").val())) {
                alert("Verifique o e-mail digitado e tente novamente!")
                event.preventDefault();
                return;
            }
            if ($("#name").val().length == 0) {
                alert("Verifique o nome e tente novamente!")
                event.preventDefault();
                return;
            }
            if ($("#text").val().length == 0) {
                alert("Verifique a mensagem e tente novamente")
                event.preventDefault();
                return;
            }

        });

        function valida() {
            inputEmail = document.querySelector('#email');

            if (!isEmail(inputEmail.value)) {

                //enquanto digita, checa se o valor está certo e se sim, remove o alert red
                $('#email').keypress(function() {
                    if (isEmail(inputEmail.value)) {
                        document.querySelector('.email-validation').classList.add('hide-self');
                        inputEmail.classList.remove('is-invalid');
                    }
                });

                //adiciona alert red caso email incorreto
                document.querySelector('.email-validation').classList.remove('hide-self');
                inputEmail.classList.add('is-invalid');

            } else {
                //remove o alert red caso email certo
                document.querySelector('.email-validation').classList.add('hide-self');
                inputEmail.classList.remove('is-invalid');
            }
        }

        function isEmail(email) {
            var regex = /^([a-zA-Z0-9_.+-])+\@(([a-zA-Z0-9-])+\.)+([a-zA-Z0-9]{2,4})+$/;
            return regex.test(email);
        }
    </script>
@endpush

<style>
    .hide-self {
        display: none;
    }

    .is-invalid {
        background-color: red;
        color: #737373;
    }
</style>
