@extends('layouts.site')

@section('headerData')
    <link rel="stylesheet" href="{{ asset('css/modules/home.css') }}">
@endsection

@section('titlepage', 'Home')
@section('meta-title', 'Página Home')
@section('meta-description', 'Entre e acesse o site da Ação Comunitária')

@section('content')


    <div class="splide">
        <div class="splide__arrows">
            <button class="splide__arrow splide__arrow--prev">
            </button>
            <button class="splide__arrow splide__arrow--next">
            </button>
        </div>
        <div class="splide__track">
            <ul class="splide__list">

                @if (count($banner) != 0)
                    @foreach ($banner as $post)
                        <li class="splide__slide">
                            <div class="banner_sistema" style="background-image: url('{{ $post->image }}')">
                                <div class="container">
                                    <div class="section_1_altura">
                                        @if ($post->text)
                                            <div class="saiba_mais">
                                                <h2 class="titulo">
                                                    {!! $post->text !!}
                                                </h2>
                                                @if ($post->id == 1)
                                                    <a href="#servicos">
                                                        <button class="btn saiba">
                                                            <a href="#servicos">
                                                                Saiba mais >>
                                                            </a>
                                                        </button>
                                                    </a>
                                                @endif
                                            </div>
                                        @endif
                                    </div>
                                </div>
                            </div>
                        </li>
                    @endforeach
                @endif
                @if (count($banner) == 0)
                    <li class="splide__slide">
                        <div class="banner1">
                            <div class="container">
                                <div class="section_1_altura">
                                </div>
                            </div>
                        </div>
                    </li>
                    <li class="splide__slide">
                        <div class="banner2">
                            <div class="container">
                                <div class="section_1_altura">
                                    <div class="saiba_mais">
                                        <h2 class="titulo">
                                            Estamos de cara nova. <br>
                                            Mas a responsabilidade <br>
                                            continua a mesma.
                                        </h2>
                                        <a href="#servicos">
                                            <button class="btn saiba">
                                                <a href="#servicos">
                                                    Saiba mais >>
                                                </a>
                                            </button>
                                        </a>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </li>
                @endif
            </ul>
        </div>
    </div>


    <div class="container">
        <div class="quem_somos">
            <div>
                <div class="img_quem_somos">
                    <img src="/img/site/card/quem_somos.png" alt="carro proserver">
                </div>
            </div>
            <div class="quem_somos_texto" id="quem-somos">
                <h3>QUEM</h3>
                <h1>SOMOS</h1>
                <p class="paragrafo">
                    A Ação Comunitária é gerenciada por um Conselho, eleito pelos associados em assembleia geral, de caráter
                    normativo e institucional. Este Conselho nomeia uma Diretoria Executiva para administrar as atividades
                    da associação junto aos seus associados. Está registrada no Ministério da Justiça como OSCIP
                    (Organização de Sociedade Civil de Interesse Público). Mantém acordo de cooperação com a Secretaria de
                    Segurança do Estado de São Paulo, para o perímetro: Av. João Dias, Marginal Pinheiros, Av. Bandeirantes,
                    Av. José Diniz.
                </p>
            </div>
        </div>
        <p class="paragrafo">
            Presta serviços aos associados através de ronda monitorada, via moto ou auto, diurna e noturna, com registro
            digital de passagens. Mantém, ainda, rádio comunitária, com treinamento de porteiros no uso dos
            equipamentos, na comunicação de chamada e registro de boletim de ocorrência 190 Polícia Civil e Polícia
            Militar. Possui projeto em implantação de monitoramento por citi-camêras e detecta.
        </p>
    </div>

    <div class="container">
        <div class="btns_quem_somos">
            <div class="card-header" id="headingOne">
                <h5 class="mb-0">
                    <button class="btn_quem_somos ativo btn_quem_somos1" id="btn_quem_somos1" type="button"
                        data-toggle="collapse" data-target="#collapseOne" aria-expanded="true" aria-controls="collapseOne">
                        CAUSA
                    </button>
                </h5>
            </div>
            <div class="card-header" id="headingTwo">
                <h5 class="mb-0">
                    <button class="btn_quem_somos collapsed btn_quem_somos2" id="btn_quem_somos2" type="button"
                        data-toggle="collapse" data-target="#collapseTwo" aria-expanded="false" aria-controls="collapseTwo">
                        OBJETIVOS
                    </button>
                </h5>
            </div>
            <div class="card-header" id="headingThree">
                <h5 class="mb-0">
                    <button class="btn_quem_somos collapsed btn_quem_somos3" id="btn_quem_somos3" type="button"
                        data-toggle="collapse" data-target="#collapseThree" aria-expanded="false"
                        aria-controls="collapseThree">
                        COMUNICAÇÃO
                    </button>
                </h5>
            </div>
            <div class="card-header" id="headingThree">
                <h5 class="mb-0">
                    <button class="btn_quem_somos collapsed btn_quem_somos4" type="button" data-toggle="collapse"
                        data-target="#collapseFour" id="btn_quem_somos4" aria-expanded="false" aria-controls="collapseFour">
                        PRINCÍPIOS
                    </button>
                </h5>
            </div>
        </div>

        <div class="accordion" id="accordionExample">
            <div class="card">
                <div id="collapseOne" class="collapse show" aria-labelledby="headingOne" data-parent="#accordionExample">
                    <div class="card-body">
                        <p class="paragrafo">
                            A Ação Comunitária da Chácara Santo Antonio é uma entidade civil, criada pela Câmara Americana
                            de Comércio de São Paulo, em 1999, com a finalidade de defender os direitos de cidadania e
                            integrar a comunidade com órgãos públicos de zeladoria e segurança. Posteriormente, em
                            01/01/2009, se constitui em associação civil, com estatutos próprios. É formada por empresas,
                            condomínios, escolas, entidades e a comunidade, que se importam com a qualidade do bairro, com o
                            trânsito de pessoas livre e seguro, sem constrangimentos de assaltos e violências. A base de
                            suas finalidades está na Declaração Universal dos Direitos da Pessoa Humana.
                        </p>
                    </div>
                </div>
            </div>
            <div class="card">

                <div id="collapseTwo" class="collapse" aria-labelledby="headingTwo" data-parent="#accordionExample">
                    <div class="card-body">
                        <ul>
                            <li class="paragrafo">
                                Promover e incentivar, com a participação da comunidade, estudos e questões fundamentais
                                de segurança pública e causas da violência;
                            </li>
                            <li class="paragrafo">
                                Promover e incentivar o conceito de cidadania na comunidade e o comprometimento com
                                vivência interativa comunitária;
                            </li>
                            <li class="paragrafo">
                                Promover os direitos de cidadania, a conduta ética nas relações sociais e os princípios
                                fundamentais dos direitos humanos;
                            </li>
                            <li class="paragrafo">
                                Integrar a comunicação de ações preventivas de segurança entre a comunidade e órgãos
                                públicos;
                            </li>
                            <li class="paragrafo">
                                Promover uma vida digna e solidária para todos os que moram e ou trabalham no perímetro do
                                bairro.
                            </li>
                        </ul>
                    </div>
                </div>
            </div>
            <div class="card">
                <div id="collapseThree" class="collapse" aria-labelledby="headingThree" data-parent="#accordionExample">
                    <div class="card-body">
                        <ul>
                            <li class="paragrafo">
                                Agilizar a comunicação de eventos e ocorrências de assaltos, roubos, furtos, com a maior
                                rapidez possível aos órgãos de segurança pública, para as devidas intervenções;
                            </li>
                            <li class="paragrafo">
                                Promover ações conscientes da dimensão humana das atitudes, com quem e para quem é destinado
                                o trabalho comunitário;
                            </li>
                            <li class="paragrafo">
                                A preservação de todas as formas de vida faz parte da contribuição de cada humano na
                                conservação do planeta, sem desperdícios, sem lixo;
                            </li>
                            <li class="paragrafo">
                                Responsabilidade de todos com a nossa segurança, extra muros.
                            </li>
                        </ul>
                    </div>
                </div>
            </div>
            <div class="card">
                <div id="collapseFour" class="collapse" aria-labelledby="headingFour" data-parent="#accordionExample">
                    <div class="card-body">
                        <p class="paragrafo">
                            O direito é um princípio constitucional, que deve ser exercido em toda a sua plenitude pelo
                            cidadão, com respeito e prudência. Ao nascer, toda pessoa recebe proteção familiar, da sociedade
                            e do estado, até obter conhecimentos e habilidades para construir uma vida digna. Toda a pessoa
                            necessita de outra para viver, ninguém vive e nem morre sem a convivência com os semelhantes. A
                            vida, o tempo, o amor, a liberdade e a verdade são bens humanos comuns a todos, e nenhum deles
                            permite posse ou propriedade. A humanidade de cada pessoa depende de como se relaciona com esses
                            bens, pois é o único caminho para reconhecer a humanidade do outro.
                        </p>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <div class="img_section2">
        <div class="container" id="parceiros">
            <div class="section_2_altura titulo_parceiro">
                <h2 class="titulo_1">ASSOCIADOS E </h2>
                <h1 class="titulo_2">parceiros</h1>
            </div>
        </div>
    </div>
    <div class="container">
        <div class="info_parceiros">
            <ul>
                <li class="paragrafo_mais_escuro">
                    Empresas, escolas, condomínios, entidades do bairro;
                </li>
                <li class="paragrafo_mais_escuro">
                    Polícia Cívil, Polícia Militar, Sub-Prefeitura e prestadores de serviços contratados
                    para as finalidades da associação;
                </li>
                <li class="paragrafo_mais_escuro">
                    Todas as pessoas que desejam promover o bem comum da comunidade.
                </li>
            </ul>
        </div>
        <div class="lista_associados">
            <div>
                <p class="paragrafo">
                    Accenture do Brasil
                </p>
                <p class="paragrafo">
                    Amcham Brasil
                </p>
                <p class="paragrafo">
                    BrasilPrev Seguros e Previdencia S.A.
                </p>
                <p class="paragrafo">
                    Braskape - Com. De Rol. e Peças Ltda
                </p>
                <p class="paragrafo">
                    Claro S.A
                </p>
                <p class="paragrafo">
                    Clinica Dr. José Olimpio
                </p>
                <p class="paragrafo">
                    Consulado Americano
                </p>
                <p class="paragrafo">
                    Condominio Contemporaneo Campo Belo
                </p>
                <p class="paragrafo">
                    Condominio Edifício Aliança
                </p>
                <p class="paragrafo">
                    Condominio Edificio Coronet I E II
                </p>
                <p class="paragrafo">
                    Condominio Edificio Evidence
                </p>
                <p class="paragrafo">
                    Condominio Edif. Guarani
                </p>
                <p class="paragrafo">
                    Cond. Resid. Jeanne D Arc
                </p>
                <p class="paragrafo">
                    Cond. Edif. Passeio Brooklin
                </p>
                <p class="paragrafo">
                    Cond. Edif.Quinta da Boa Vista
                </p>
            </div>
            <div>
                <p class="paragrafo">
                    Cond. Edif. Reserva Granja Julieta
                </p>
                <p class="paragrafo">
                    Cond. Edif. Olimpic Ch. Sto Antonio
                </p>
                <p class="paragrafo">
                    Cond. Edif. Sonatta
                </p>
                <p class="paragrafo">
                    Cond. Edif. Scott Joplin
                </p>
                <p class="paragrafo">
                    Cond. Gafisa Like Alto da Boa Vista
                </p>
                <p class="paragrafo">
                    Cond. Jardins Granja Julieta
                </p>
                <p class="paragrafo">
                    Cond. Resid. Granja Julieta
                </p>
                <p class="paragrafo">
                    Cond. Residencial Jardins de Provence
                </p>
                <p class="paragrafo">
                    Cond. Residencial RSVP
                </p>
                <p class="paragrafo">
                    Cond. Resid. Sta Helena e Sto Alberto
                </p>
                <p class="paragrafo">
                    Cond. Rersid. Vila Borghese
                </p>
                <p class="paragrafo">
                    Contaget - Contabidade Ltda
                </p>
                <p class="paragrafo">
                    Deloite Touche Tohmatsu ltda
                </p>
                <p class="paragrafo">
                    Dupiza Com. Imp. Export. Distr. Ltda
                </p>
                <p class="paragrafo">
                    Dell Technologies
                </p>
            </div>
            <div>
                <p class="paragrafo">
                    Frangaria
                </p>
                <p class="paragrafo">
                    GMA Contadores
                </p>
                <p class="paragrafo">
                    Helanda de Lau Chio Cheng
                </p>
                <p class="paragrafo">
                    Ind. Plástica Azulplast Ltda
                </p>
                <p class="paragrafo">
                    Jelprint Formulários Ltda
                </p>
                <p class="paragrafo">
                    Rua Branco de Araujo 393
                </p>
                <p class="paragrafo">
                    Laboratórios Pfizer Ltda
                </p>
                <p class="paragrafo">
                    Mil Horas Viagens e Turismo Ltda
                </p>
                <p class="paragrafo">
                    Stocktotal
                </p>
                <p class="paragrafo">
                    TEOR - Terapia e Orientação
                </p>
                <p class="paragrafo">
                    Transamerica Flat Nações Unidas
                </p>
                <p class="paragrafo">
                    UNIP - Assupero
                </p>
                <p class="paragrafo">
                    União Qumica
                </p>
                <p class="paragrafo"> Zona Sul Noticias
            </div>
            </p>
        </div>
    </div>

    <div class="img_section3">
        <div class="container" id="monitoramento">
            <div class="section_3_altura titulo_monitoramento">
                <h1 class="titulo_2">monitoramento</h1>
            </div>
        </div>
    </div>

    <div class="container">
        <div class="btns_monitoramento">
            <div class="card-header" id="monitoramentoOne">
                <h5 class="mb-0">
                    <button class="btn_monitoramento ativo btn_monitoramento1" type="button" data-toggle="collapse"
                        data-target="#collapse2One" aria-expanded="true" aria-controls="collapse2One">
                        DETECTA
                    </button>
                </h5>
            </div>
            <div class="card-header" id="monitoramentoTwo">
                <h5 class="mb-0">
                    <button class="btn_monitoramento collapsed btn_monitoramento2" type="button" data-toggle="collapse"
                        data-target="#collapse2Two" aria-expanded="false" aria-controls="collapse2Two">
                        CITY CÂMERAS
                    </button>
                </h5>
            </div>
            <div class="card-header" id="monitoramentoThree">
                <h5 class="mb-0">
                    <button class="btn_monitoramento collapsed btn_monitoramento3" type="button" data-toggle="collapse"
                        data-target="#collapse2Three" aria-expanded="false" aria-controls="collapse2Three">
                        RÁDIOS
                    </button>
                </h5>
            </div>
            <div class="card-header" id="monitoramentoFour">
                <h5 class="mb-0">
                    <button class="btn_monitoramento collapsed btn_monitoramento4" type="button" data-toggle="collapse"
                        data-target="#collapse2Four" aria-expanded="false" aria-controls="collapse2Four">
                        CONTROLE <br>
                        DE RONDA
                    </button>
                </h5>
            </div>
        </div>

        <div class="accordion" id="accordionExample2">
            <div class="card">
                <div id="collapse2One" class="collapse show" aria-labelledby="monitoramentoOne"
                    data-parent="#accordionExample2">
                    <div class="card-body card_monitoramento">
                        <div>
                            <img src="/img/site/card/monitoramento.png">
                        </div>
                        <div class="card_monitoramento_texto">
                            <h2 class="titulo_card">Sistema Detecta</h2>
                            <p class="paragrafo">
                                Ação Comunitária da Chácara Santo Antônio e Região é uma das <b>primeiras Organizações da
                                    Sociedade Civil </b> a celebrar este Acordo de Cooperação para dotar nosso bairro com
                                câmeras de
                                monitoramento do <b> Projeto Detecta </b> da Secretaria de Segurança Pública do Estado de
                                São
                                Paulo,
                                que estarão ligadas diretamente com os órgãos de prevenção e repressão das polícias
                                estaduais e a Guarda Civil Metropolitana.
                            </p>
                            <p class="paragrafo">
                                Câmaras leitoras de placas informarão imediatamente à Polícia Militar a presença de algum
                                veículo com algum tipo de restrição delituosa ou suspeita. Veículos roubados, furtados, que
                                tenham sido vistos em participação de algum crime ou cujos ocupantes tenham praticado algum,
                                emitirão um alarme imediato à viatura da PM mais próxima.
                            </p>
                            <p class="paragrafo">
                                <b> A utilidade do Sistema Detecta é infinita</b>, e vai contribuir muito para tornar nosso
                                bairro
                                ainda mais seguro participação das empresas, de condomínios empresariais ou residenciais,
                                dos shoppings, do comércio em geral, dos moradores e das escolas é imprescindível e
                                necessária para agilizar a implantação dos equipamentos no nosso bairro.
                            </p>
                        </div>
                    </div>
                </div>
            </div>
            <div class="card">
                <div id="collapse2Two" class="collapse" aria-labelledby="monitoramentoTwo"
                    data-parent="#accordionExample2">
                    <div class="card-body card_monitoramento">
                        <div>
                            <img src="/img/site/card/monitoramento2.png">
                        </div>
                        <div class="card_monitoramento_texto">
                            <h2 class="titulo_card">City Câmeras</h2>
                            <p class="paragrafo">
                                O <b> Programa City Câmeras </b> da prefeitura de São Paulo teve início em 2017, com a
                                integração de
                                249 câmeras da região do Brás, com o apoio dos comerciantes locais. Suas imagens armazenadas
                                em nuvem são compartilhadas com a <b> Guarda Civil Metropolitana, Polícia Militar e Polícia
                                    Civil</b>.
                            </p>
                            <p class="paragrafo">
                                Atualmente, o Programa possui <b> mais de 3.500 câmeras</b>, sendo 1.000 equipamentos da
                                prefeitura
                                e cerca de 2.500 câmeras de particulares, entre comércio, indústrias e residências.
                            </p>
                            <p class="paragrafo">
                                Diversos condomínios da Chácara Santo Antonio participam deste Programa, possibilitando Aos
                                órgãos públicos, o acesso às imagens é em tempo real e são gravadas, visando detectar,
                                prevenir e reagir a situações de emergência, além de <b> inibir a ação de criminosos </b> e
                                aumentar
                                a segurança e o bem-estar dos moradores do bairro.
                            </p>
                            <div class="logo_city">
                                <img src="img/site/card/city.png">
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="card">
                <div id="collapse2Three" class="collapse" aria-labelledby="monitoramentoThree"
                    data-parent="#accordionExample2">
                    <div class="card-body card_monitoramento">
                        <div>
                            <img src="/img/site/card/monitoramento3.png">
                        </div>
                        <div class="card_monitoramento_texto">
                            <div class="titulo_radio">
                                <h2 class="titulo_card">
                                    Rádios
                                </h2>
                                &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
                                <h1>
                                    <img src="img/site/card/ptt.png">
                                </h1>
                            </div>
                            <p class="paragrafo">
                                <b>
                                    A INOVAPTT ESTÁ PRESENTE NA INTEGRAÇÃO DE SEGURANÇA.
                                </b>
                            </p>
                            <p class="paragrafo">
                                A Inovaptt atende a Ação Comunitária da Chácara Santo Antônio, através da implantação da
                                solução POC (PTT Over Celular).
                            </p>
                            <p class="paragrafo">
                                Esta solução é uma aplicação profissional de comunicação com tecnologia push to talk, que
                                emula todas as funções de uma rádio comunicador.
                            </p>
                            <p class="paragrafo">
                                A tecnologia PTT via celular usa as redes IP1, Wi-Fi, 3G, 4G ou LTE para conexão de equipes
                                operacionais, possibilitando a <b>comunicação integrada</b>.
                            </p>
                            <p class="paragrafo">
                                Os condomínios e empresas que fazem parte do projeto precisam utilizar os radiocomunicadores
                                para que os associados fiquem em contato permanente.
                            </p>
                            <p class="paragrafo">
                                Mas, para isso, é muito importante que os funcionários sejam treinados para atuar <b> de
                                    forma
                                    preventiva em situações de emergências</b>.
                            </p>
                        </div>
                    </div>
                </div>
            </div>
            <div class="card">
                <div id="collapse2Four" class="collapse" aria-labelledby="monitoramentoFour"
                    data-parent="#accordionExample2">
                    <div class="card-body card_monitoramento">
                        <div>
                            <img src="/img/site/card/monitoramento4.png">
                        </div>
                        <div class="card_monitoramento_texto">
                            <h2 class="titulo_card">Controle de Ronda Detecta</h2>
                            <p class="paragrafo">
                                Contamos com um controle das atividades de nossas operações em tempo real e on-line, via
                                celular GPS e Qcode nas portarias, assim podemos monitoramos toda ronda de nossos
                                associados, temos controle das operações com segurança e transparência. Enviamos o relatório
                                mensalmente a nossos clientes.
                            </p>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <div class="img_section4">
        <div class="container" id="noticias">
            <div class="section_4_altura titulo_parceiro">
                <h2 class="titulo_1">AS </h2>
                <h1 class="titulo_2">notícias</h1>
            </div>
        </div>
    </div>
    <div class="container">
        <div>
            @if (count($posts) == 0)
                <div class="item text-center">
                    <h3 class="py-2 mb-0 titulo">Não há notícias cadastradas.</h3>
                </div>
            @else
                <div class="container ">
                    <div class="noticias row">
                        @foreach ($posts as $key => $p)
                            <div class="col-6 noticia">
                                <h5 class="card-title titulo_noticia">{{ $p->title }}</h5>
                                <div class="txt_noticia">
                                    <p class="paragrafo">
                                        {{ \Carbon\Carbon::parse($p->date)->translatedFormat('M  d, Y') }}
                                        Visualizações {{ $p->contagem }}</p>
                                    <div class="leia">
                                        <a
                                            href="/noticia/{{ strtolower(str_replace(' ', '-', preg_replace(['/(á|à|ã|â|ä)/', '/(Á|À|Ã|Â|Ä)/', '/(é|è|ê|ë)/', '/(É|È|Ê|Ë)/', '/(í|ì|î|ï)/', '/(Í|Ì|Î|Ï)/', '/(ó|ò|õ|ô|ö)/', '/(Ó|Ò|Õ|Ô|Ö)/', '/(ú|ù|û|ü)/', '/(Ú|Ù|Û|Ü)/', '/(ñ)/', '/(Ñ)/'], explode(' ', 'a A e E i I o O u U n N'), $p->title))) }}">
                                            LEIA MAIS >>
                                        </a>
                                    </div>

                                </div>
                            </div>
                        @endforeach
                    </div>
                </div>
            @endif

        </div>
    </div>

    <div class="img_section5">
        <div class="container" id="servicos">
            <div class="section_5_altura titulo_parceiro">
                <h2 class="titulo_1">NOSSOS</h2>
                <h1 class="titulo_2">serviços</h1>
            </div>
        </div>
    </div>
    <div class="bg_formulario">
        <div class="container">
            <h1 class="titulo">Formulário</h1>
            <form action="{{ route('formulario') }}" method="POST" id="formulario" enctype="multipart/form-data">
                @csrf
                <div>
                    <div>
                        <input class="form" type="text" placeholder="Razão Social:" name="razao" id="razao"
                            value="{{ old('razao') }}" required>
                    </div>
                    <div>
                        <input class="form" type="text" placeholder="Nome:" name="name" id="name"
                            value="{{ old('name') }}" required>
                    </div>
                    <div>
                        <input class="form form_email" type="text" placeholder="E-mail" value="{{ old('email') }}"
                            name="email" id="email" onblur="valida()" required>
                        <div class="alert alert-danger email-validation hide-self form form_email" style="margin: 1px">
                            Digite um e-mail valido
                        </div>
                    </div>
                    <div>
                        <input class="form " type="text" placeholder="Telefone" name="telefone"
                            value="{{ old('telefone') }}" id="telefone" required>
                    </div>
                    <div>
                        <input class="form " type="text" placeholder="Assunto" name="assunto"
                            value="{{ old('assunto') }}" id="assunto" required>
                    </div>
                    <div>
                        <textarea class="form" type="text" rows="5" name="campo_aberto" id="campo_aberto"
                            placeholder="Campo aberto para digitação:" required>{{ old('campo_aberto') }}</textarea>
                    </div>
                </div>
                <button class="btn btn-dark saiba">
                    <b>Enviar </b>
                </button>
            </form>
        </div>
    </div>

    <div class="img_section6">
        <div class="container" id="contato">
            <div class="section_6_altura titulo_parceiro">
                <h2 class="titulo_1">NOSSO</h2>
                <h1 class="titulo_2">contato</h1>
            </div>
        </div>
    </div>

    <div class="img_section7">
        <div class="container" id="servicos">
            <div class="section_7_altura ">
                <div class="contato">
                    <div class="contato_texto">
                        <p class="paragrafo">
                            AÇÃO COMUNITÁRIA DA CHÁCARA SANTO ANTÔNIO E REGIÃO <br>
                            CNPJ: 10.645.102/0001-18 INSCR. ESTADUAL: ISENTA <br>
                            INSCR. MUNICIPAL (SP): 3.897.815-6
                        </p>
                        <p class="paragrafo">
                            R. Antônio das Chagas, 180 – Baia 8 - Chácara Santo Antônio (Zona Sul), São Paulo - SP,
                            04714-000
                        </p>
                        <p class="paragrafo">
                            Telefone: (11) 99139-0235
                        </p>
                        <p class="paragrafo">
                            Email: faleconosco@chacarasantoantoniosp.org.br
                        </p>
                    </div>
                    <div>
                        <iframe class="mapa"
                            src="https://www.google.com/maps/embed?pb=!1m18!1m12!1m3!1d3655.177667395618!2d-46.70035203650036!3d-23.63380752088081!2m3!1f0!2f0!3f0!3m2!1i1024!2i768!4f13.1!3m3!1m2!1s0x94ce50ee6006672b%3A0xd4cda21748efe098!2sR.%20Ant%C3%B4nio%20das%20Chagas%2C%20180%20-%20Ch%C3%A1cara%20Santo%20Ant%C3%B4nio%20(Zona%20Sul)%2C%20S%C3%A3o%20Paulo%20-%20SP%2C%2004714-000!5e0!3m2!1spt-BR!2sbr!4v1666094359250!5m2!1spt-BR!2sbr"
                            allowfullscreen="" loading="lazy" referrerpolicy="no-referrer-when-downgrade"></iframe>
                    </div>
                </div>
            </div>
        </div>
    </div>

    @component('components.popup_automatico')
    @endcomponent


@endsection

@push('footerData')
    <script>
        //Ação de quando fecha o collapse dos btns
        $('#collapseOne').on('hidden.bs.collapse', function() {
            document.querySelector('.btn_quem_somos1').classList.remove('ativo');
        })
        $('#collapseOne').on('show.bs.collapse', function() {
            document.querySelector('.btn_quem_somos1').classList.add('ativo');
        })

        $('#collapseTwo').on('hidden.bs.collapse', function() {
            document.querySelector('.btn_quem_somos2').classList.remove('ativo');
        })
        $('#collapseTwo').on('show.bs.collapse', function() {
            document.querySelector('.btn_quem_somos2').classList.add('ativo');
        })

        $('#collapseThree').on('hidden.bs.collapse', function() {
            document.querySelector('.btn_quem_somos3').classList.remove('ativo');
        })
        $('#collapseThree').on('show.bs.collapse', function() {
            document.querySelector('.btn_quem_somos3').classList.add('ativo');
        })

        $('#collapseFour').on('hidden.bs.collapse', function() {
            document.querySelector('.btn_quem_somos4').classList.remove('ativo');
        })
        $('#collapseFour').on('show.bs.collapse', function() {
            document.querySelector('.btn_quem_somos4').classList.add('ativo');
        })

        //monitoramento
        $('#collapse2One').on('hidden.bs.collapse', function() {
            document.querySelector('.btn_monitoramento1').classList.remove('ativo');
        })
        $('#collapse2One').on('show.bs.collapse', function() {
            document.querySelector('.btn_monitoramento1').classList.add('ativo');
        })

        $('#collapse2Two').on('hidden.bs.collapse', function() {
            document.querySelector('.btn_monitoramento2').classList.remove('ativo');
        })
        $('#collapse2Two').on('show.bs.collapse', function() {
            document.querySelector('.btn_monitoramento2').classList.add('ativo');
        })

        $('#collapse2Three').on('hidden.bs.collapse', function() {
            document.querySelector('.btn_monitoramento3').classList.remove('ativo');
        })
        $('#collapse2Three').on('show.bs.collapse', function() {
            document.querySelector('.btn_monitoramento3').classList.add('ativo');
        })

        $('#collapse2Four').on('hidden.bs.collapse', function() {
            document.querySelector('.btn_monitoramento4').classList.remove('ativo');
        })
        $('#collapse2Four').on('show.bs.collapse', function() {
            document.querySelector('.btn_monitoramento4').classList.add('ativo');
        })

        // Carrosel
        new Splide('.splide', {
            type: 'loop',
            height: '515px',
            speed: 1000,
            rewindSpeed: 5000,
            interval: 10000,
            autoplay: 'true',
            breakpoints: {
                600: {
                    direction: 'rrb',
                    perPage: 1,
                },
            },
        }).mount();

        $("#formulario").submit(function(event) {
            if (!isEmail($("#email").val())) {
                alert("Verifique o e-mail digitado e tente novamente!")
                event.preventDefault();
                return;
            }
            if ($("#telefone").val().length < 15) {
                alert("Verifique o telefone e tente novamente!")
                event.preventDefault();
                return;
            }
        });

        function valida() {
            inputEmail = document.querySelector('#email');

            if (!isEmail(inputEmail.value)) {

                //enquanto digita, checa se o valor está certo e se sim, remove o alert red
                $('#email').keypress(function() {
                    if (isEmail(inputEmail.value)) {
                        document.querySelector('.email-validation').classList.add('hide-self');
                        inputEmail.classList.remove('is-invalid');
                    }
                });

                //adiciona alert red caso email incorreto
                document.querySelector('.email-validation').classList.remove('hide-self');
                inputEmail.classList.add('is-invalid');

            } else {
                //remove o alert red caso email certo
                document.querySelector('.email-validation').classList.add('hide-self');
                inputEmail.classList.remove('is-invalid');
            }
        }

        function isEmail(email) {
            var regex = /^([a-zA-Z0-9_.+-])+\@(([a-zA-Z0-9-])+\.)+([a-zA-Z0-9]{2,4})+$/;
            return regex.test(email);
        }

        $('#telefone').mask('(00) 00000-0000');
    </script>
@endpush
