@extends('layouts.site')

@section('headerData')
    <link rel="stylesheet" href="{{ asset('css/modules/noticia_view.css') }}">
@endsection

@section('titlepage', 'Notícias')
@section('meta-title', 'Página Notícias')
@section('meta-description', 'Entre e acesse o site da Secretaria de Turismo de Arujá')

@section('content')
    <div class="container">
        <div class="entrada">
            <div>
                <h2>Notícias</h2>
            </div>
            <div class="entrada_pagina">
                <a class="link" href="/">
                    <h6>Home</h6>
                </a>
                -
                <a class="link" href="{{ route('noticias') }}">
                    <h6><b>Notícias</b></h6>
                </a>
            </div>
        </div>
    </div>

    <div class="container">
        <div>
            <div class="conteudo">
                <div>
                    <div class="item" style="background-image: url('{{ asset($noticia->image) }}') ">
                        <img class="imgtarget" src="{{ $noticia->image }}">
                    </div>
                </div>
                <div class="conteudo_titulo">
                    <h2>{{ $noticia->title }}</h2>
                    <div class="conteudo_titulo_data">
                        <p>{{ \Carbon\Carbon::parse($noticia->date)->translatedFormat('d M Y') }}</p>
                    </div>
                </div>
            </div>
            <div class="conteudo_texto">
                {!! $noticia->txt !!}
            </div>
        </div>
    </div>

    <div class="popup-home none">
        <div class="content">
            <i class="far fa-times-circle"></i>
            <img src>
        </div>
    </div>


@endsection

@push('footerData')
    <script>
        // A $( document ).ready() block.
        $(document).ready(function() {
            resizeFooter();
        });
        $(window).resize(function() {
            resizeFooter();
        });

        function resizeFooter() {
            $("#contato").each(function() {
                $(this).css('height', this.clientWidth / 2.5)
            })
        }

        $("#formulario").submit(function(event) {
            if (!isEmail($("#email").val())) {
                alert("Verifique o e-mail digitado e tente novamente!")
                event.preventDefault();
                return;
            }
            if ($("#name").val().length == 0) {
                alert("Verifique o nome e tente novamente!")
                event.preventDefault();
                return;
            }
            if ($("#text").val().length == 0) {
                alert("Verifique a mensagem e tente novamente")
                event.preventDefault();
                return;
            }
        });

        function valida() {
            inputEmail = document.querySelector('#email');

            if (!isEmail(inputEmail.value)) {
                //enquanto digita, checa se o valor está certo e se sim, remove o alert red
                $('#email').keypress(function() {
                    if (isEmail(inputEmail.value)) {
                        document.querySelector('.email-validation').classList.add('hide-self');
                        inputEmail.classList.remove('is-invalid');
                    }
                });

                //adiciona alert red caso email incorreto
                document.querySelector('.email-validation').classList.remove('hide-self');
                inputEmail.classList.add('is-invalid');

            } else {
                //remove o alert red caso email certo
                document.querySelector('.email-validation').classList.add('hide-self');
                inputEmail.classList.remove('is-invalid');
            }
        }

        function isEmail(email) {
            var regex = /^([a-zA-Z0-9_.+-])+\@(([a-zA-Z0-9-])+\.)+([a-zA-Z0-9]{2,4})+$/;
            return regex.test(email);
        }
    </script>

    <script>
        const popup = document.querySelector('.popup-home');
        const content = document.querySelector('.popup-home .content');
        const close = document.querySelector('.popup-home .content i');
        const imgPopup = document.querySelector('.popup-home .content img');
        const imgs = document.querySelectorAll('.imgtarget');

        imgs.forEach((img) => {
            img.addEventListener('click', function() {
                if (popup.classList.contains('none')) {
                    imgPopup.src = img.src;
                    popup.classList.remove('none');
                    popup.style.animation = "opening .3s forwards";
                } else {
                    popup.style.animation = "close .3s forwards";
                    setTimeout(() => {
                        popup.classList.add('none');
                    }, 700)
                }
            })

            popup.addEventListener('click', function() {
                if (popup.classList.contains('none')) {
                    popup.classList.remove('none');
                    popup.style.animation = "opening .3s forwards";
                } else {
                    popup.style.animation = "close .3s forwards";
                    setTimeout(() => {
                        popup.classList.add('none');
                    }, 700)
                }
            })

            close.addEventListener('click', function() {
                if (popup.classList.contains('none')) {
                    popup.classList.remove('none');
                    popup.style.animation = "opening .3s forwards";
                } else {
                    popup.style.animation = "close .3s forwards";
                    setTimeout(() => {
                        popup.classList.add('none');
                    }, 700)
                }
            })

        })
    </script>
@endpush

<style>
    .hide-self {
        display: none;
    }

    .is-invalid {
        background-color: red;
        color: #fff;
    }
</style>
