<?php

use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Route;

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
*/

Route::get('/', ['App\Http\Controllers\ClientController', 'home'])->name('home');

Route::get('/noticias', ['App\Http\Controllers\ClientController', 'noticias'])->name('noticias');
Route::get('/noticia/{id}', ['App\Http\Controllers\ClientController', 'noticia_view'])->name('noticia_view');

Route::post('/registercustom', ['App\Http\Controllers\RegisterController', 'store']);

Auth::routes(['verify' => true]);

//email
Route::post('/contato_email', ['App\Http\Controllers\EmailController', 'contatoEmail'])->name('formulario');

// Route group for admin
Route::group(['prefix' => 'admin',  'middleware' => 'checkAdmin'], function () {
    Route::get('/', ['App\Http\Controllers\AdminController', 'index'])->name('admin_index');

    Route::get('/posts', ['App\Http\Controllers\AdminController', 'posts'])->name('admin_posts');
    Route::post('/posts/new', ['App\Http\Controllers\AdminController', 'posts_add'])->name('admin_posts_add');
    Route::post('/posts/new/tinymce_data', ['App\Http\Controllers\AdminController', 'posts_add_tinymce_data']);
    Route::post('/posts/search', ['App\Http\Controllers\AdminController', 'post_search'])->name('admin_post_search');
    Route::post('/posts/edit', ['App\Http\Controllers\AdminController', 'post_edit'])->name('admin_post_edit');
    Route::post('/posts/delete', ['App\Http\Controllers\AdminController', 'post_delete'])->name('admin_post_delete');

    Route::get('/posts_banner', ['App\Http\Controllers\AdminController', 'posts_banner'])->name('admin_posts_banner');
    Route::post('/posts_banner/new', ['App\Http\Controllers\AdminController', 'posts_banner_add'])->name('admin_posts_banner_add');
    Route::post('/posts_banner/new/tinymce_data', ['App\Http\Controllers\AdminController', 'posts_banner_add_tinymce_data']);
    Route::post('/posts_banner/search', ['App\Http\Controllers\AdminController', 'post_banner_search'])->name('admin_post_banner_search');
    Route::post('/posts_banner/edit', ['App\Http\Controllers\AdminController', 'post_banner_edit'])->name('admin_post_banner_edit');
    Route::post('/posts_banner/delete', ['App\Http\Controllers\AdminController', 'post_banner_delete'])->name('admin_post_banner_delete');

    Route::get('/administradores', ['App\Http\Controllers\AdminController', 'administradores'])->name('admin_administradores');
    Route::post('/admin/add', ['App\Http\Controllers\AdminController', 'admin_add'])->name('admin_add');
    Route::post('/admin/add/respponsavel', ['App\Http\Controllers\AdminController', 'admin_add_responsavel'])->name('admin_add_responsavel');

    Route::post('/admin/remove', ['App\Http\Controllers\AdminController', 'admin_remove'])->name('admin_remove');
    Route::post('/admin/user/delete', ['App\Http\Controllers\AdminController', 'user_delete'])->name('user_delete');
    Route::post('/admin/user/edit', ['App\Http\Controllers\AdminController', 'user_edit'])->name('user_edit');
    Route::post('/admin/user/search', ['App\Http\Controllers\AdminController', 'user_search'])->name('admin_user_search');

    Route::post('/create_user', ['App\Http\Controllers\RegisterController', 'create_user'])->name('admin_add_user');

    Route::get('/configuracao', ['App\Http\Controllers\RegisterController', 'configuracao'])->name('admin_configuracao');
    Route::post('/configuracao/edit', ['App\Http\Controllers\RegisterController', 'configuracao_edit'])->name('admin_configuracao_edit');
});

Route::get('/error', function () {
    if (Auth::user()->level == 1) {
        if (Auth::user()->email_verified_at != '') {
            return redirect()->route('admin_index');
        }
    } else {
        return view('site.error');
    }
})->name('error');
