<?php $__env->startSection('titlepage', 'Notícias - Admin'); ?>

<?php $__env->startSection('content'); ?>
    <div class="content-admin">
        <?php $__env->startComponent('components.admin.nav'); ?>
        <?php echo $__env->renderComponent(); ?>
        <div class="content card">
            <h3 class="card-header">Banner <a class="btn btn_custom" data-toggle="collapse" href="#openNewPost" role="button"
                    aria-expanded="false" aria-controls="openNewPost">Adicionar Banner
                    +</a></h3>
            <div class="collapse" id="openNewPost">
                <div class="card card-body">
                    <form action="<?php echo e(route('admin_posts_banner_add')); ?>" method="POST" enctype="multipart/form-data">
                        <?php echo csrf_field(); ?>
                        <div class="form-group" style="display: flex">
                            <div>
                                <label for="image">Imagem de Capa e que ficara no banner</label>
                                <h6><b>Obs:</b> Para uma melhor resolução, procure utilizar uma foto com as medidas
                                    superiores a 850 x 450 .</h6>
                                <input required class="form-control py-1" type="file" accept="image/*" id="image"
                                    name="image">
                            </div>
                            <img id="image_real" class="miniatura">
                        </div>
                        <div class="form-group">
                            <label for="text">Conteúdo do Banner</label>
                            <textarea class="form-control" name="text" id="text" class="txt"></textarea>
                        </div>
                        <div class="form-group">
                            <button type="submit" class="btn btn_custom">Salvar</button>
                            <a class="btn btn-danger" data-toggle="collapse" href="#openNewPost" role="button"
                                aria-expanded="false" aria-controls="openNewPost">Cancelar</a>
                        </div>
                    </form>
                </div>
            </div>

            <div class="card-body items-fotos-admin">
                <div class="header">
                    <div class="col1">
                        <h5>Imagem</h5>
                    </div>
                    <div class="col3">
                        <h5>Ações</h5>
                    </div>
                </div>

                <div class="content">
                    <?php if(count($posts) == 0): ?>
                        <div class="item">
                            <h3 class="py-2 mb-0" style="text-align: center; width: 100%">Não há banners cadastrados.</h3>
                        </div>
                    <?php endif; ?>

                    <?php $__currentLoopData = $posts; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $foto): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <div class="item">
                            <div class="col1">
                                <a href="<?php echo e($foto->image); ?>" target="_blank">
                                    <img src="<?php echo e($foto->image); ?>" alt="Foto">
                                </a>
                            </div>
                            <div class="col3">
                                <div class="actions">
                                    <a class="btn btn-warning" data-toggle="collapse"
                                        href="#collapse_id_<?php echo e($foto->id); ?>" role="button" aria-expanded="false"
                                        aria-controls="collapse_id_<?php echo e($foto->id); ?>"><i class="fas fa-edit"></i></a>
                                    <form action="<?php echo e(route('admin_post_banner_delete')); ?>" method="POST"
                                        onsubmit="return confirm('Tem certeza que deseja remover esta Foto?')">
                                        <?php echo csrf_field(); ?>
                                        <input type="hidden" name="id" value="<?php echo e($foto->id); ?>">
                                        <button type="submit" class="btn btn-danger"><i class="fas fa-trash"></i></button>
                                    </form>
                                </div>
                            </div>
                        </div>
                        <div class="collapse" id="collapse_id_<?php echo e($foto->id); ?>">
                            <div class="card card-body">
                                <form action="<?php echo e(route('admin_post_banner_edit')); ?>" method="POST"
                                    enctype="multipart/form-data">
                                    <?php echo csrf_field(); ?>
                                    <input type="hidden" name="id" value="<?php echo e($foto->id); ?>">
                                    <div class="form-group">
                                        <label for="image">
                                            <?php if($foto->image): ?>
                                                Imagem Definida. Caso queira
                                                alterar, selecione outra foto.
                                            <?php else: ?>
                                                Imagem de Capa
                                            <?php endif; ?>
                                        </label>
                                        <input class="form-control py-1" type="file" accept="image/*" id="image"
                                            name="image">
                                    </div>
                                    <div class="form-group">
                                        <label for="text">Conteúdo do Banner</label>
                                        <textarea class="form-control" name="text" id="txt_banner_id_<?php echo e($foto->text); ?>" class="txt"><?php echo e($foto->text); ?></textarea>
                                    </div>
                                    <div class="form-group">
                                        <button type="submit" class="btn btn-success">Salvar</button>
                                        <a class="btn btn-danger" data-toggle="collapse"
                                            href="#collapse_id_<?php echo e($foto->id); ?>" role="button" aria-expanded="false"
                                            aria-controls="collapse_id_<?php echo e($foto->id); ?>">Cancelar</a>
                                    </div>
                                </form>

                                <script>
                                    tinymce.init({
                                        selector: '#txt_banner_id_<?php echo e($foto->id); ?>',
                                        language: 'pt_BR',
                                        height: 500,
                                        theme: 'silver',
                                        convert_urls: false,
                                        statusbar: false,
                                        image_title: true,
                                        automatic_uploads: true,
                                        images_upload_url: '<?php echo e(url('/admin/posts/new/tinymce_data')); ?>',
                                        file_picker_types: 'image',
                                        file_picker_callback: function(cb, value, meta) {

                                            var input = document.createElement('input');
                                            input.setAttribute('type', 'file');
                                            input.setAttribute('accept', 'image/*');

                                            input.onchange = function() {
                                                var file = this.files[0];

                                                var reader = new FileReader();
                                                reader.readAsDataURL(file);
                                                reader.onload = function() {
                                                    var id = 'blobid' + (new Date()).getTime();
                                                    var blobCache = tinymce.activeEditor.editorUpload.blobCache;
                                                    var base64 = reader.result.split(',')[1];
                                                    var blobInfo = blobCache.create(id, file, base64);
                                                    blobCache.add(blobInfo);
                                                    cb(blobInfo.blobUri(), {
                                                        title: file.name
                                                    });
                                                };
                                            };
                                            input.click();
                                        },
                                        plugins: 'print preview searchreplace autolink directionality visualblocks visualchars fullscreen image link media template codesample table charmap hr pagebreak nonbreaking anchor toc insertdatetime advlist lists wordcount imagetools textpattern help',
                                        toolbar1: 'formatselect | bold italic strikethrough forecolor backcolor | link | alignleft aligncenter alignright alignjustify  | numlist bullist outdent indent  | removeformat',

                                    });
                                </script>
                            </div>
                        </div>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </div>
            </div>

        </div>
    </div>

    <script>
        tinymce.init({
            selector: '#text',
            language: 'pt_BR',
            height: 500,
            theme: 'silver',
            convert_urls: false,
            statusbar: false,
            image_title: true,
            automatic_uploads: true,
            images_upload_url: '<?php echo e(url('/admin/posts/new/tinymce_data')); ?>',
            file_picker_types: 'image',
            file_picker_callback: function(cb, value, meta) {

                var input = document.createElement('input');
                input.setAttribute('type', 'file');
                input.setAttribute('accept', 'image/*');

                input.onchange = function() {
                    var file = this.files[0];

                    var reader = new FileReader();
                    reader.readAsDataURL(file);
                    reader.onload = function() {
                        var id = 'blobid' + (new Date()).getTime();
                        var blobCache = tinymce.activeEditor.editorUpload.blobCache;
                        var base64 = reader.result.split(',')[1];
                        var blobInfo = blobCache.create(id, file, base64);
                        blobCache.add(blobInfo);
                        cb(blobInfo.blobUri(), {
                            title: file.name
                        });
                    };
                };
                input.click();
            },
            plugins: 'print preview searchreplace autolink directionality visualblocks visualchars fullscreen image link media template codesample table charmap hr pagebreak nonbreaking anchor toc insertdatetime advlist lists wordcount imagetools textpattern help',
            toolbar1: 'formatselect | bold italic strikethrough forecolor backcolor | link | alignleft aligncenter alignright alignjustify  | numlist bullist outdent indent  | removeformat',

        });

        $(".select2").select2();

        var expanded = false;

        function showCheckboxes() {
            var checkboxes = document.getElementById("checkboxes");
            if (!expanded) {
                checkboxes.style.display = "block";
                expanded = true;
            } else {
                checkboxes.style.display = "none";
                expanded = false;
            }
        }
    </script>

    <?php $__env->startComponent('components.popup_automatico'); ?>
    <?php echo $__env->renderComponent(); ?>

<?php $__env->stopSection(); ?>
<?php $__env->startPush('footerData'); ?>
    <script>
        document.getElementById("image").onchange = function() {
            var reader = new FileReader();
            reader.onload = function(e) {
                // get loaded data and render thumbnail.
                document.getElementById("image_real").src = e.target.result;
            };
            // read the image file as a data URL.
            reader.readAsDataURL(this.files[0]);
        };
    </script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/wwhoom/public_html/layout/acao_comunitaria_laravel/resources/views/admin/posts_banner.blade.php ENDPATH**/ ?>