<!DOCTYPE html>
<html lang="pt-BR">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    
    <meta http-equiv="X-UA-Compatible" content="ie=edge">

    <!-- Primary Meta Tags -->
    <meta name="title" content="<?php echo $__env->yieldContent('meta-title'); ?> | Ação Comunitária">
    <meta name="description" content="<?php echo $__env->yieldContent('meta-description'); ?>">

    <!-- Open Graph / Facebook -->
    <meta property="og:type" content="website">
    <meta property="og:url" content="<?php echo e(URL::current()); ?>">
    <meta property="og:title" content="<?php echo $__env->yieldContent('meta-title'); ?> | Ação Comunitária">
    <meta property="og:description" content="<?php echo $__env->yieldContent('meta-description'); ?>">
    <meta property="og:image" content="<?php echo e(asset('img/meta/brush.png')); ?>">

    <!-- Twitter -->
    <meta property="twitter:card" content="summary_large_image">
    <meta property="twitter:url" content="<?php echo e(URL::current()); ?>">
    <meta property="twitter:title" content="<?php echo $__env->yieldContent('meta-title'); ?> | Ação Comunitária">
    <meta property="twitter:description" content="<?php echo $__env->yieldContent('meta-description'); ?>">
    <meta property="twitter:image" content="<?php echo e(asset('img/meta/brush.png')); ?>">

    <!-- Favicon section -->
    <link rel="apple-touch-icon" sizes="57x57" href="<?php echo e(asset('img/favicon/apple-icon-57x57.png')); ?>">
    <link rel="apple-touch-icon" sizes="60x60" href="<?php echo e(asset('img/favicon/apple-icon-60x60.png')); ?>">
    <link rel="apple-touch-icon" sizes="72x72" href="<?php echo e(asset('img/favicon/apple-icon-72x72.png')); ?>">
    <link rel="apple-touch-icon" sizes="76x76" href="<?php echo e(asset('img/favicon/apple-icon-76x76.png')); ?>">
    <link rel="apple-touch-icon" sizes="114x114" href="<?php echo e(asset('img/favicon/apple-icon-114x114.png')); ?>">
    <link rel="apple-touch-icon" sizes="120x120" href="<?php echo e(asset('img/favicon/apple-icon-120x120.png')); ?>">
    <link rel="apple-touch-icon" sizes="144x144" href="<?php echo e(asset('img/favicon/apple-icon-144x144.png')); ?>">
    <link rel="apple-touch-icon" sizes="152x152" href="<?php echo e(asset('img/favicon/apple-icon-152x152.png')); ?>">
    <link rel="apple-touch-icon" sizes="180x180" href="<?php echo e(asset('img/favicon/apple-icon-180x180.png')); ?>">
    <link rel="icon" type="image/png" sizes="192x192" href="<?php echo e(asset('img/favicon/android-icon-192x192.png')); ?>">
    <link rel="icon" type="image/png" sizes="32x32" href="<?php echo e(asset('img/favicon/favicon-32x32.png')); ?>">
    <link rel="icon" type="image/png" sizes="96x96" href="<?php echo e(asset('img/favicon/favicon-96x96.png')); ?>">
    <link rel="icon" type="image/png" sizes="16x16" href="<?php echo e(asset('img/favicon/favicon-16x16.png')); ?>">
    <link rel="manifest" href="<?php echo e(asset('img/favicon/manifest.json')); ?>">
    <meta name="msapplication-TileColor" content="#ffffff">
    <meta name="msapplication-TileImage" content="<?php echo e(asset('img/favicon/ms-icon-144x144.png')); ?>">
    <meta name="theme-color" content="#ffffff">
    <!-- End favicon section -->
    <script src="https://www.google.com/recaptcha/api.js" async defer></script>


    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/@splidejs/splide@latest/dist/css/splide.min.css">

    
    <link rel="stylesheet" href="<?php echo e(asset('plugins/fontawesome/css/all.min.css')); ?>">

    <!-- Bootstrap CSS -->
    <link rel="stylesheet" href="https://stackpath.bootstrapcdn.com/bootstrap/4.1.3/css/bootstrap.min.css">

    
    <link rel="stylesheet" href="<?php echo e(asset('plugins/lightbox/css/lightbox.css')); ?>">

    <!-- personal files -->
    <link rel="stylesheet" href="<?php echo e(asset('css/styles.css')); ?>">
    <?php echo $__env->yieldContent('headerData'); ?>
    <?php echo $__env->yieldPushContent('headerData'); ?>
    <!-- end personal files -->

    <title><?php echo $__env->yieldContent('titlepage'); ?> | Ação Comunitária</title>
</head>

<body>
    
    <?php $__env->startComponent('components.header'); ?>
    <?php echo $__env->renderComponent(); ?>

    <?php echo $__env->yieldContent('content'); ?>

    <?php $__env->startComponent('components.footer'); ?>
    <?php echo $__env->renderComponent(); ?>

    
    <script src="https://code.jquery.com/jquery-3.5.1.min.js"
        integrity="sha256-9/aliU8dGd2tb6OSsuzixeV4y/faTqgFtohetphbbj0=" crossorigin="anonymous"></script>

    
    <script src="<?php echo e(asset('plugins/jquery_mask/jquery.mask.min.js')); ?>"></script>

    <script src="https://cdn.jsdelivr.net/npm/bootstrap@4.6.0/dist/js/bootstrap.bundle.min.js"
        integrity="sha384-Piv4xVNRyMGpqkS2by6br4gNJ7DXjqk09RmUpJ8jgGtD7zP9yug3goQfGII0yAns" crossorigin="anonymous">
    </script>

    
    <script src="<?php echo e(asset('plugins/lightbox/js/lightbox.js')); ?>"></script>
    <script src="https://cdn.jsdelivr.net/npm/@splidejs/splide@latest/dist/js/splide.min.js"></script>
    <script src="<?php echo e(asset('js/scripts.js')); ?>"></script>
    <?php echo $__env->yieldContent('footerData'); ?>
    <?php echo $__env->yieldPushContent('footerData'); ?>
    
</body>

</html>
<?php /**PATH /home/wwhoom/public_html/layout/acao_comunitaria_laravel/resources/views/layouts/site.blade.php ENDPATH**/ ?>