<?php $__env->startSection('headerData'); ?>
    <link rel="stylesheet" href="<?php echo e(asset('css/modules/noticia_view.css')); ?>">
<?php $__env->stopSection(); ?>

<?php $__env->startSection('titlepage', 'Notícias'); ?>
<?php $__env->startSection('meta-title', 'Página Notícias'); ?>
<?php $__env->startSection('meta-description', 'Entre e acesse o site da Secretaria de Turismo de Arujá'); ?>

<?php $__env->startSection('content'); ?>
    <div class="container">
        <div class="entrada">
            <div>
                <h2>Notícias</h2>
            </div>
            <div class="entrada_pagina">
                <a class="link" href="/">
                    <h6>Home</h6>
                </a>
                -
                <a class="link" href="<?php echo e(route('noticias')); ?>">
                    <h6><b>Notícias</b></h6>
                </a>
            </div>
        </div>
    </div>

    <div class="container">
        <div>
            <div class="conteudo">
                <div>
                    <div class="item" style="background-image: url('<?php echo e(asset($noticia->image)); ?>') ">
                        <img class="imgtarget" src="<?php echo e($noticia->image); ?>">
                    </div>
                </div>
                <div class="conteudo_titulo">
                    <h2><?php echo e($noticia->title); ?></h2>
                    <div class="conteudo_titulo_data">
                        <p><?php echo e(\Carbon\Carbon::parse($noticia->date)->translatedFormat('d M Y')); ?></p>
                    </div>
                </div>
            </div>
            <div class="conteudo_texto">
                <?php echo $noticia->txt; ?>

            </div>
        </div>
    </div>

    <div class="popup-home none">
        <div class="content">
            <i class="far fa-times-circle"></i>
            <img src>
        </div>
    </div>


<?php $__env->stopSection(); ?>

<?php $__env->startPush('footerData'); ?>
    <script>
        // A $( document ).ready() block.
        $(document).ready(function() {
            resizeFooter();
        });
        $(window).resize(function() {
            resizeFooter();
        });

        function resizeFooter() {
            $("#contato").each(function() {
                $(this).css('height', this.clientWidth / 2.5)
            })
        }

        $("#formulario").submit(function(event) {
            if (!isEmail($("#email").val())) {
                alert("Verifique o e-mail digitado e tente novamente!")
                event.preventDefault();
                return;
            }
            if ($("#name").val().length == 0) {
                alert("Verifique o nome e tente novamente!")
                event.preventDefault();
                return;
            }
            if ($("#text").val().length == 0) {
                alert("Verifique a mensagem e tente novamente")
                event.preventDefault();
                return;
            }
        });

        function valida() {
            inputEmail = document.querySelector('#email');

            if (!isEmail(inputEmail.value)) {
                //enquanto digita, checa se o valor está certo e se sim, remove o alert red
                $('#email').keypress(function() {
                    if (isEmail(inputEmail.value)) {
                        document.querySelector('.email-validation').classList.add('hide-self');
                        inputEmail.classList.remove('is-invalid');
                    }
                });

                //adiciona alert red caso email incorreto
                document.querySelector('.email-validation').classList.remove('hide-self');
                inputEmail.classList.add('is-invalid');

            } else {
                //remove o alert red caso email certo
                document.querySelector('.email-validation').classList.add('hide-self');
                inputEmail.classList.remove('is-invalid');
            }
        }

        function isEmail(email) {
            var regex = /^([a-zA-Z0-9_.+-])+\@(([a-zA-Z0-9-])+\.)+([a-zA-Z0-9]{2,4})+$/;
            return regex.test(email);
        }
    </script>

    <script>
        const popup = document.querySelector('.popup-home');
        const content = document.querySelector('.popup-home .content');
        const close = document.querySelector('.popup-home .content i');
        const imgPopup = document.querySelector('.popup-home .content img');
        const imgs = document.querySelectorAll('.imgtarget');

        imgs.forEach((img) => {
            img.addEventListener('click', function() {
                if (popup.classList.contains('none')) {
                    imgPopup.src = img.src;
                    popup.classList.remove('none');
                    popup.style.animation = "opening .3s forwards";
                } else {
                    popup.style.animation = "close .3s forwards";
                    setTimeout(() => {
                        popup.classList.add('none');
                    }, 700)
                }
            })

            popup.addEventListener('click', function() {
                if (popup.classList.contains('none')) {
                    popup.classList.remove('none');
                    popup.style.animation = "opening .3s forwards";
                } else {
                    popup.style.animation = "close .3s forwards";
                    setTimeout(() => {
                        popup.classList.add('none');
                    }, 700)
                }
            })

            close.addEventListener('click', function() {
                if (popup.classList.contains('none')) {
                    popup.classList.remove('none');
                    popup.style.animation = "opening .3s forwards";
                } else {
                    popup.style.animation = "close .3s forwards";
                    setTimeout(() => {
                        popup.classList.add('none');
                    }, 700)
                }
            })

        })
    </script>
<?php $__env->stopPush(); ?>

<style>
    .hide-self {
        display: none;
    }

    .is-invalid {
        background-color: red;
        color: #fff;
    }
</style>

<?php echo $__env->make('layouts.site', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/wwhoom/public_html/layout/acao_comunitaria_laravel/resources/views/site/noticia_view.blade.php ENDPATH**/ ?>