<?php $__env->startSection('titlepage', 'Notícias - Admin'); ?>

<?php $__env->startSection('content'); ?>
    <div class="content-admin">
        <?php $__env->startComponent('components.admin.nav'); ?>
        <?php echo $__env->renderComponent(); ?>
        <div class="content card">
            <h3 class="card-header">Notícias <a class="btn btn_custom" data-toggle="collapse" href="#openNewPost" role="button"
                    aria-expanded="false" aria-controls="openNewPost">Adicionar Notícia
                    +</a></h3>
            <div class="collapse" id="openNewPost">
                <div class="card card-body">
                    <form id="add_post" action="<?php echo e(route('admin_posts_add')); ?>" method="POST"
                        enctype="multipart/form-data">
                        <?php echo csrf_field(); ?>
                        <div class="form-group">
                            <label for="title">Titulo da Notícia</label>
                            <input required type="text" name="title" id="title" class="form-control"
                                maxlength="80">
                        </div>
                        <div class="form-group">
                            <label for="description">Descrição Resumida</label>
                            <input required type="text" name="description" id="description" class="form-control"
                                maxlength="150">
                        </div>
                        <div class="form-group" style="display: flex">
                            <div>
                                <label for="date">Data da Notícia</label>
                                <input required type="date" name="date" id="date" class="form-control"
                                    style="width: max-content">
                            </div>

                            <div style="margin:0 2rem">
                                <label for="image">Imagem de Capa</label>
                                <input required class="form-control py-1" type="file" accept="image/*" id="image"
                                    name="image">
                            </div>
                        </div>
                        <div class="form-group">
                            <label for="txt">Conteúdo da Notícia</label>
                            <textarea class="form-control" name="txt" id="txt" class="txt"></textarea>
                        </div>
                        <div class="form-group">
                            <button type="submit" class="btn btn_custom">Salvar Notícia</button>
                            <button type="reset" class="btn btn_custom2">Limpar Dados</button>
                            <a class="btn btn-danger" data-toggle="collapse" href="#openNewPost" role="button"
                                aria-expanded="false" aria-controls="openNewPost">Cancelar</a>
                        </div>
                    </form>
                </div>
            </div>
            <div class="card-body items-post-admin">
                <div class="header">
                    <div class="col1">
                        <h5>Título</h5>
                    </div>
                    <div class="col2">
                        <h5>Data</h5>
                    </div>
                    <div class="col3">
                        <h5>Ações</h5>
                    </div>
                </div>
                <div class="search">
                    <form action="<?php echo e(route('admin_post_search')); ?>" method="POST" enctype="multipart/form-data">
                        <?php echo csrf_field(); ?>
                        <div class="col1 form-input">
                            <small id="label1" class="form-text text-muted pl-1">
                                Procurar pelo título da Notícia
                            </small>
                            <input type="text" name="title" id="title" class="form-control" maxlength="80"
                                placeholder="Digite algo sobre o título para filtrar" aria-describedby="label1"
                                <?php if(isset($paramstitle)): ?> value="<?php echo e($paramstitle); ?>" <?php endif; ?>>
                        </div>
                        <div class="col2 form-input">
                            <small id="label2" class="form-text text-muted pl-1">
                                Procurar pela data
                            </small>
                            <input type="date" name="date" id="date" class="form-control"
                                aria-describedby="label2"
                                <?php if(isset($paramsdate)): ?> value="<?php echo e($paramsdate); ?>" <?php endif; ?>>
                        </div>
                        <div class="col3 actions">
                            <button type="submit" class="btn btn-primary"><i class="fas fa-search"></i></button>
                        </div>
                    </form>
                </div>
                <div class="content">
                    <?php if(count($posts) == 0): ?>
                        <div class="item">
                            <h3 class="py-2 mb-0" style="text-align: center; width: 100%">Não há notícias cadastrados.
                            </h3>
                        </div>
                    <?php endif; ?>

                    <?php $__currentLoopData = $posts; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $post): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <div class="item">
                            <div class="col1">
                                <p><?php echo e($post->title); ?> - Visualização <?php echo e($post->contagem); ?></p>
                            </div>
                            <div class="col2">
                                <p><?php echo e(date('d-m-Y', strtotime($post->date))); ?></p>
                            </div>
                            <div class="col3">
                                <div class="actions">
                                    <a class="btn btn_custom2" data-toggle="collapse"
                                        href="#collapse_id_<?php echo e($post->id); ?>" role="button" aria-expanded="false"
                                        aria-controls="collapse_id_<?php echo e($post->id); ?>"><i class="fas fa-edit"></i></a>
                                    <form action="<?php echo e(route('admin_post_delete')); ?>" method="POST"
                                        onsubmit="return confirm('Tem certeza que deseja remover Noticia?')">
                                        <?php echo csrf_field(); ?>
                                        <input type="hidden" name="id" value="<?php echo e($post->id); ?>">
                                        <button type="submit" class="btn btn-danger"><i
                                                class="fas fa-trash"></i></button>
                                    </form>
                                </div>
                            </div>
                        </div>
                        <div class="collapse" id="collapse_id_<?php echo e($post->id); ?>">
                            <div class="card card-body">
                                <form action="<?php echo e(route('admin_post_edit')); ?>" method="POST"
                                    enctype="multipart/form-data">
                                    <?php echo csrf_field(); ?>
                                    <input type="hidden" name="id" value="<?php echo e($post->id); ?>">
                                    <div class="form-group">
                                        <label for="title">Titulo do Post</label>
                                        <input required type="text" name="title" id="title"
                                            class="form-control" maxlength="80" value="<?php echo e($post->title); ?>">
                                    </div>
                                    <div class="form-group">
                                        <label for="description">Descrição Resumida</label>
                                        <input required type="text" name="description" id="description"
                                            class="form-control" maxlength="150" value="<?php echo e($post->description); ?>">
                                    </div>
                                    <div class="form-group">
                                        <label for="date">Data do Post</label>
                                        <input required type="date" name="date" id="date"
                                            class="form-control" value="<?php echo e($post->date); ?>">
                                    </div>
                                    <div class="form-group">
                                        <label for="image">
                                            <?php if($post->image): ?>
                                                Imagem de Capa Definida. Caso queira alterar, selecione outra foto.
                                            <?php else: ?>
                                                Imagem de Capa
                                            <?php endif; ?>
                                        </label>
                                        <input class="form-control py-1" type="file" accept="image/*" id="image"
                                            name="image">
                                    </div>
                                    <div class="form-group">
                                        <label for="txt">Conteúdo do Post</label>
                                        <textarea class="form-control" name="txt" id="txt_post_id_<?php echo e($post->id); ?>" class="txt"><?php echo e($post->txt); ?></textarea>
                                    </div>
                                    <div class="form-group">
                                        <button type="submit" class="btn btn_custom">Salvar Post</button>
                                        <button type="reset" class="btn btn_custom2">Limpar Dados</button>
                                        <a class="btn btn-danger" data-toggle="collapse"
                                            href="#collapse_id_<?php echo e($post->id); ?>" role="button" aria-expanded="false"
                                            aria-controls="collapse_id_<?php echo e($post->id); ?>">Cancelar</a>
                                    </div>
                                </form>

                                <script>
                                    tinymce.init({
                                        selector: '#txt_post_id_<?php echo e($post->id); ?>',
                                        language: 'pt_BR',
                                        height: 500,
                                        theme: 'silver',
                                        convert_urls: false,
                                        statusbar: false,
                                        image_title: true,
                                        automatic_uploads: true,
                                        images_upload_url: '<?php echo e(url('/admin/posts/new/tinymce_data')); ?>',
                                        file_picker_types: 'image',
                                        file_picker_callback: function(cb, value, meta) {

                                            var input = document.createElement('input');
                                            input.setAttribute('type', 'file');
                                            input.setAttribute('accept', 'image/*');

                                            input.onchange = function() {
                                                var file = this.files[0];

                                                var reader = new FileReader();
                                                reader.readAsDataURL(file);
                                                reader.onload = function() {
                                                    var id = 'blobid' + (new Date()).getTime();
                                                    var blobCache = tinymce.activeEditor.editorUpload.blobCache;
                                                    var base64 = reader.result.split(',')[1];
                                                    var blobInfo = blobCache.create(id, file, base64);
                                                    blobCache.add(blobInfo);
                                                    cb(blobInfo.blobUri(), {
                                                        title: file.name
                                                    });
                                                };
                                            };
                                            input.click();
                                        },
                                        plugins: 'print preview searchreplace autolink directionality visualblocks visualchars fullscreen image link media template codesample table charmap hr pagebreak nonbreaking anchor toc insertdatetime advlist lists wordcount imagetools textpattern help',
                                        toolbar1: 'formatselect | bold italic strikethrough forecolor backcolor | link | alignleft aligncenter alignright alignjustify  | numlist bullist outdent indent  | removeformat',

                                    });
                                </script>
                            </div>
                        </div>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                    <?php if(empty($posts)): ?>
                        <div class="item p-2">
                            <h2 style="text-align: center; width: 100%" class="pl-2 mb-0 btn btn-danger">Nenhum post
                                encontrado.
                                </h4>
                        </div>
                    <?php endif; ?>
                </div>
            </div>
        </div>
    </div>

    <script>
        tinymce.init({
            selector: '#txt',
            language: 'pt_BR',
            height: 500,
            theme: 'silver',
            convert_urls: false,
            statusbar: false,
            image_title: true,
            automatic_uploads: true,
            images_upload_url: '<?php echo e(url(' / admin / posts / new / tinymce_data ')); ?>',
            file_picker_types: 'image',
            file_picker_callback: function(cb, value, meta) {
                var input = document.createElement('input');
                input.setAttribute('type', 'file');
                input.setAttribute('accept', 'image/*');
                input.onchange = function() {
                    var file = this.files[0];
                    var reader = new FileReader();
                    reader.readAsDataURL(file);
                    reader.onload = function() {
                        var id = 'blobid' + (new Date()).getTime();
                        var blobCache = tinymce.activeEditor.editorUpload.blobCache;
                        var base64 = reader.result.split(',')[1];
                        var blobInfo = blobCache.create(id, file, base64);
                        blobCache.add(blobInfo);
                        cb(blobInfo.blobUri(), {
                            title: file.name
                        });
                    };
                };
                input.click();
            },
            plugins: 'print preview searchreplace autolink directionality visualblocks visualchars fullscreen image link media template codesample table charmap hr pagebreak nonbreaking anchor toc insertdatetime advlist lists wordcount imagetools textpattern help',
            toolbar1: 'formatselect | bold italic strikethrough forecolor backcolor | link | alignleft aligncenter alignright alignjustify  | numlist bullist outdent indent  | removeformat',
        });
    </script>

    <?php $__env->startComponent('components.popup_automatico'); ?>
    <?php echo $__env->renderComponent(); ?>

<?php $__env->stopSection(); ?>

<?php $__env->startPush('footerData'); ?>
    <script>
        function validateTamanho() {
            if (document.getElementById('image').files[0].size > 5242880) {
                return true;
            } else {
                return false;
            }
        }

        $("#add_post").submit(function(event) {
            if (validateTamanho()) {
                alert("Sua imagem possui mais do que 5MB. Por gentileza utilize uma imagem menor.")
                event.preventDefault();
                return;
            }
        });
    </script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/wwhoom/public_html/layout/acao_comunitaria_laravel/resources/views/admin/posts.blade.php ENDPATH**/ ?>