<div class="container">
    <section>
        <div class="img_efeito_fale @if ('/en' == $_SERVER['REQUEST_URI']) img_efeito_fale_en @endif">
            <img src="/img/site/efeito/retangulo_fale_conosco.png">
        </div>
        <h1 class="fale_conosco_titulo">
            @lang('messages.fale_conosco')
        </h1>
        <div class="fale_conosco_section">
            <div class="contato">
                <div class="fale_icones">
                    <div class="fale_iconess">
                        <div>
                            <img src="/img/site/icones/email.png">
                        </div>
                        <div class="fale_icone_txt">
                            <p class="titulo_icone_fale">E-MAIL</p>
                            <p class="valor_icone_fale">contato@hoomweb.com</p>
                        </div>
                    </div>
                    <div class="fale_iconess">
                        <div>
                            <img src="/img/site/icones/telefone.png">
                        </div>
                        <div class="fale_icone_txt">
                            <p class="titulo_icone_fale">@lang('messages.telefone_hoom')</p>
                            <p class="valor_icone_fale">(11) 4274-0565</p>
                        </div>
                    </div>
                </div>
                <div class="mt-3">
                    <div class="fale_icones fale_icones1">
                        <div>
                            <img src="/img/site/icones/local.png">
                        </div>
                        <div class="fale_icone_txt endereco">
                            <p class="titulo_icone_fale">@lang('messages.endereco')</p>
                            <p class="valor_icone_fale">
                                @lang('messages.endereco_hoom')</p>
                        </div>
                    </div>
                </div>
                <div class="formulario" id="contato">
                    <form action="{{ route('contato_email') }}" method="POST" id="formulario">
                        @csrf
                        <label class="input_formulario" for="nome">@lang('messages.nome') <span
                                class="_red_">*</span></label>
                        <input type="text" class="form-control" placeholder="@lang('messages.seu_nome')" name="nome"
                            id="nome" required>
                        <label class="input_formulario" for="E-mail">E-mail: <span class="_red_">*</span></label>
                        <input type="text" class="form-control" placeholder="email@site.com.br" name="email"
                            id="email" onblur="valida()" required>
                        <div class="alert alert-danger email-validation hide-self">
                            @lang('messages.email_valido')
                        </div>
                        <label class="input_formulario" for="telefone">@lang('messages.telefone')<span
                                class="_red_">*</span></label>
                        <input type="text" class="form-control" placeholder="(00) 00000-0000" name="telefone"
                            id="telefone" required>
                        <label class="input_formulario" for="mensagem"> @lang('messages.mensagem')<span
                                class="_red_">*</span></label>
                        <textarea required class="form-control" placeholder="@lang('messages.sua_mensagem')" rows="6" name="mensagem" id="text"
                            required></textarea>
                        <div class="btn_fale ">
                            {{-- <div class="g-recaptcha " data-sitekey="6LdGNOMjAAAAADkpNua9UuZbt62fgMBXYA_ltLML"
                                data-callback="enableBtn" expired-callback="disableBtn"></div> --}}
                            <div class="h-captcha" data-sitekey="02c09242-3019-4daf-8f4b-a2db44456783"
                                data-callback="enableBtn">
                            </div>
                            <button type="submit" class="btn_verde btn btn_enviar" disabled="disabled">
                                @lang('messages.btn_enviar')</button>
                        </div>
                    </form>
                </div>
            </div>
            <div>
                <div class="efeito_mapa">
                    <img src="/img/site/efeito/retangulo_mapa.png">
                </div>
                <div class="mapa">
                    <iframe
                        src="https://www.google.com/maps/embed?pb=!1m18!1m12!1m3!1d3661.842878477204!2d-46.32858218502529!3d-23.39390068476625!2m3!1f0!2f0!3f0!3m2!1i1024!2i768!4f13.1!3m3!1m2!1s0x94ce877e96fe0293%3A0x5697d56dd4bb071!2sHoomweb!5e0!3m2!1spt-BR!2sbr!4v1665059455676!5m2!1spt-BR!2sbr"
                        allowfullscreen="" loading="lazy" referrerpolicy="no-referrer-when-downgrade"></iframe>
                </div>
            </div>
        </div>
    </section>
</div>

@component('components.popup_automatico')
@endcomponent

@push('footerData')
    <script src='https://www.hCaptcha.com/1/api.js' async defer></script>
    <script>
        function enableBtn() {
            $(".btn.btn_enviar").removeAttr("disabled");
        }

        function disableBtn() {
            $(".btn.btn_enviar").prop('disabled', true); //disable clicked button
        }

        function valida() {

            inputEmail = document.querySelector('#email');

            if (!isEmail(inputEmail.value)) {

                //enquanto digita, checa se o valor está certo e se sim, remove o alert red
                $('#email').keypress(function() {
                    if (isEmail(inputEmail.value)) {
                        document.querySelector('.email-validation').classList.add('hide-self');
                        inputEmail.classList.remove('is-invalid');
                    }
                });

                //adiciona alert red caso email incorreto
                document.querySelector('.email-validation').classList.remove('hide-self');
                inputEmail.classList.add('is-invalid');

            } else {
                //remove o alert red caso email certo
                document.querySelector('.email-validation').classList.add('hide-self');
                inputEmail.classList.remove('is-invalid');
            }

            if (dominio == 'qualicorp.com.br') {
                alert("E-mail @qualicorp.com.br não é permitido")
                document.querySelector('.email-validation').classList.remove('hide-self');
                inputEmail.classList.add('is-invalid');
            }
        }

        function isEmail(email) {
            var regex = /^([a-zA-Z0-9_.+-])+\@(([a-zA-Z0-9-])+\.)+([a-zA-Z0-9]{2,4})+$/;
            return regex.test(email);
        }

        $('#telephone').mask('(00) 00000-0000');
    </script>
@endpush
