@extends('layouts.site')

@section('headerData')
    <link rel="stylesheet" href="{{ asset('css/modules/home.css') }}">
@endsection

@section('titlepage', 'Home')
@section('meta-title', 'Página Home')
@section('meta-description', 'Entre e acesse o site da Hoomweb')

@section('content')

    <div class="img_section1">
        <div class="container">
            <section class="section_1_altura">
                <div class="texto_section_1">
                    <div>
                        <h1 class="txt_section1">
                            @lang('messages.transformamos')
                        </h1>
                        <h1 class="txt_section1">
                            @lang('messages.ideias')
                        </h1>
                        <p class="txt_section1_p">
                            @lang('messages.ajudamos') <br>
                            @lang('messages.alcancar')
                        </p>
                    </div>
                    {{-- TODO: FALTA AJUSTAR EM INGLES O BUSSINES NO MOBILE --}}
                    <div class="efeito__1 @if ('/en' == $_SERVER['REQUEST_URI']) efeito__1_en @endif">
                        <div class="retangulo_criativa">
                            <img src="/img/site/efeito/retangulo_verde.png">
                        </div>
                        <div class="efeito_1">
                            <img src="/img/site/efeito/efeito_1.png">
                        </div>
                        <div class="negocio">
                            <h3 class="negocios">@lang('messages.negocios')</h3>
                        </div>
                        <div class="efeito_2">
                            <img src="/img/site/efeito/efeito_2.png">
                        </div>
                        @if ('/en' != $_SERVER['REQUEST_URI'])
                            <div class="efeito_acento">
                                <img src="/img/site/efeito/acento.png">
                            </div>
                        @endif
                    </div>
                </div>
            </section>
        </div>
    </div>
    <div class="img_section2">
        <div class="container">
            <section class="section_2_altura">
                <div class="titulo_section2" id="servicos">
                    <div class="titulo_section2_delimitador">
                        <h1 class="txt_section2_titulo">
                            @lang('messages.servicos_titulo')
                        </h1>
                    </div>
                </div>
                <div>
                    <div class="efeito_3">
                        <img src="/img/site/efeito/efeito_3.png">
                    </div>
                    <div class="efeito_4">
                        <img src="/img/site/efeito/efeito_4.png">
                    </div>
                </div>
                <div class="celular_seu_logo">
                    <div class="celular_seulogo">
                        <img src="/img/site/celular/celular_seu_logo.png">
                    </div>
                    <div class="texto_section2">
                        <h2 class="txt_section2_subtitulo">
                            @lang('messages.aplicativo')
                        </h2>
                        <p class="txt_section2_p">
                            @lang('messages.criamos')

                        </p>
                        <a
                            href="
                        @if ('/en' == $_SERVER['REQUEST_URI'] ||
                            '/en/about_us' == $_SERVER['REQUEST_URI'] ||
                            '/en/portfolio' == $_SERVER['REQUEST_URI']) /en/portfolio @endif
                        @if ('/pt' == $_SERVER['REQUEST_URI'] ||
                            '/pt/quem-somos' == $_SERVER['REQUEST_URI'] ||
                            '/pt/portfolio' == $_SERVER['REQUEST_URI']) /pt/portfolio @endif
                        @if ('/' == $_SERVER['REQUEST_URI'] ||
                            '/sobre-nos' == $_SERVER['REQUEST_URI'] ||
                            '/portfolio' == $_SERVER['REQUEST_URI']) /portfolio @endif
                    ">
                            <button class="btn-dark btn veja_cases">
                                {{-- @lang('messages.btn_veja') --}}
                                @lang('messages.btn_portfolio')
                            </button>
                        </a>
                    </div>
                </div>
            </section>
        </div>
    </div>
    <div class="container">
        <section class="section_cards_altura">
            <div class="cards">
                <div class="card_item">
                    <div class="card_img_item">
                        <img src="/img/site/card/dafoods.png">
                    </div>
                    <h4 class="titulo_card">@lang('messages.card_1_titulo')</h4>
                    <p class="paragrafo_card">
                        @lang('messages.card_1_conteudo')
                    </p>

                    <a
                        href="
                        @if ('/en' == $_SERVER['REQUEST_URI'] ||
                            '/en/about_us' == $_SERVER['REQUEST_URI'] ||
                            '/en/portfolio' == $_SERVER['REQUEST_URI']) /en/portfolio @endif
                        @if ('/pt' == $_SERVER['REQUEST_URI'] ||
                            '/pt/quem-somos' == $_SERVER['REQUEST_URI'] ||
                            '/pt/portfolio' == $_SERVER['REQUEST_URI']) /pt/portfolio @endif
                        @if ('/' == $_SERVER['REQUEST_URI'] ||
                            '/sobre-nos' == $_SERVER['REQUEST_URI'] ||
                            '/portfolio' == $_SERVER['REQUEST_URI']) /portfolio @endif
                    ">
                        <button class="btn-dark btn veja_cases_section_3"> @lang('messages.btn_portfolio')</button>
                    </a>
                </div>
                <div class="card_item">
                    <div class="card_img_item">
                        <img src="/img/site/card/laptop.png">
                    </div>
                    <h4 class="titulo_card">@lang('messages.card_2_titulo')</h4>
                    <p class="paragrafo_card">
                        @lang('messages.card_2_conteudo')
                    </p>
                    <a
                        href="
                        @if ('/en' == $_SERVER['REQUEST_URI'] ||
                            '/en/about_us' == $_SERVER['REQUEST_URI'] ||
                            '/en/portfolio' == $_SERVER['REQUEST_URI']) /en/portfolio @endif
                        @if ('/pt' == $_SERVER['REQUEST_URI'] ||
                            '/pt/quem-somos' == $_SERVER['REQUEST_URI'] ||
                            '/pt/portfolio' == $_SERVER['REQUEST_URI']) /pt/portfolio @endif
                        @if ('/' == $_SERVER['REQUEST_URI'] ||
                            '/sobre-nos' == $_SERVER['REQUEST_URI'] ||
                            '/portfolio' == $_SERVER['REQUEST_URI']) /portfolio @endif
                    ">
                        <button class="btn-dark btn veja_cases_section_3"> @lang('messages.btn_portfolio')</button>
                    </a>
                </div>
                <div class="card_item">
                    <div class="card_img_item">
                        <img src="/img/site/card/smart_tv.png">
                    </div>
                    <h4 class="titulo_card">@lang('messages.card_3_titulo')</h4>
                    <p class="paragrafo_card">
                        @lang('messages.card_2_conteudo')
                    </p>
                    <a
                        href="
                        @if ('/en' == $_SERVER['REQUEST_URI'] ||
                            '/en/about_us' == $_SERVER['REQUEST_URI'] ||
                            '/en/portfolio' == $_SERVER['REQUEST_URI']) /en/portfolio @endif
                        @if ('/pt' == $_SERVER['REQUEST_URI'] ||
                            '/pt/quem-somos' == $_SERVER['REQUEST_URI'] ||
                            '/pt/portfolio' == $_SERVER['REQUEST_URI']) /pt/portfolio @endif
                        @if ('/' == $_SERVER['REQUEST_URI'] ||
                            '/sobre-nos' == $_SERVER['REQUEST_URI'] ||
                            '/portfolio' == $_SERVER['REQUEST_URI']) /portfolio @endif
                    ">
                        <button class="btn-dark btn veja_cases_section_3"> @lang('messages.btn_portfolio')</button>
                    </a>
                </div>
            </div>
            {{-- <div class="mkt">
                <div class="conecta @if ('/en' == $_SERVER['REQUEST_URI']) conecta_en @endif">
                    <img src="/img/site/efeito/efeito_5.png">
                    <h5 class="aqui_conecta ">@lang('messages.aqui_conecta')
                        <br>
                        @lang('messages.conecta')
                    </h5>
                </div>
                <h4 class="mkt_titulo">@lang('messages.mkt_digital')</h4>
                <p class="mkt_paragrafo">
                    @lang('messages.mkt_paragrafo')
                </p>
                <button class="btn-dark btn veja_cases_white">@lang('messages.btn_entre_contato')</button>
            </div> --}}
        </section>
    </div>
    <div class="container" id="cases">
        <div
            class="efeito_retangulo_cases @if ('/en' == $_SERVER['REQUEST_URI']) efeito_retangulo_cases_en @endif @if ('/pt' == $_SERVER['REQUEST_URI']) efeito_retangulo_cases_pt @endif">
            <img src="/img/site/efeito/retangulo_cases.png">
        </div>
        <h1 class="cases_sucesso">@lang('messages.nossos_cases')</h1>
    </div>

    <div class="img_section3">
        <div class="container">
            <section class="section_3_altura">
                <div class="uoon_section">
                    <div class="uoon_texto">
                        <h2 class="uoon_titulo">Uoon</h2>
                        <p class="uoon_paragrafo">
                            @lang('messages.uoon_paragrafo_1')
                        </p>
                        <p class="uoon_paragrafo">
                            @lang('messages.uoon_paragrafo_2')
                        </p>
                        <p class="uoon_paragrafo">

                            @lang('messages.uoon_paragrafo_3')
                        </p>
                        <p class="uoon_paragrafo">

                            @lang('messages.uoon_paragrafo_4')
                        </p>
                        <a
                            href="
                        @if ('/' == $_SERVER['REQUEST_URI']) /#contato @endif
                        @if ('/en' == $_SERVER['REQUEST_URI']) /en#contato @endif
                        @if ('/pt' == $_SERVER['REQUEST_URI']) /pt#contato @endif
                        ">
                            <button class="btn-dark btn btn_verde">@lang('messages.btn_entre_contato')</button>
                        </a>
                    </div>
                    <div>
                        <div class="uoon_img">
                            <img src="/img/site/celular/celular_uoon.png">
                        </div>
                    </div>
                </div>
            </section>
        </div>
    </div>
    <div class="img_section4">
        <div class="container">
            <section class="section_4_altura">
                <div class="vn3_section">
                    <div>
                        <div class="vn3_img">
                            <img src="/img/site/celular/celular_vn3.png">
                        </div>
                    </div>
                    <div class="vn3_texto">
                        <h2 class="vn3_titulo">VN3</h2>
                        <p class="vn3_paragrafo">
                            @lang('messages.vn3_paragrafo_1')
                        </p>
                        <p class="vn3_paragrafo">
                            @lang('messages.vn3_paragrafo_2')
                        </p>
                        <p class="vn3_paragrafo">
                            @lang('messages.vn3_paragrafo_3')
                        </p>
                        <a
                            href="
                        @if ('/' == $_SERVER['REQUEST_URI']) /#contato @endif
                        @if ('/en' == $_SERVER['REQUEST_URI']) /en#contato @endif
                        @if ('/pt' == $_SERVER['REQUEST_URI']) /pt#contato @endif
                        ">
                            <button class="btn-dark btn btn_verde">@lang('messages.btn_entre_contato')</button>
                        </a>
                    </div>
                </div>
            </section>
        </div>
    </div>
    <div class="btn_portfolio_in_cases">
        <div class="btn_portfolio">
            <a class="nav-link"
                href="
                    @if ('/en' == $_SERVER['REQUEST_URI'] ||
                        '/en/about_us' == $_SERVER['REQUEST_URI'] ||
                        '/en/portfolio' == $_SERVER['REQUEST_URI']) /en/portfolio @endif
                    @if ('/pt' == $_SERVER['REQUEST_URI'] ||
                        '/pt/quem-somos' == $_SERVER['REQUEST_URI'] ||
                        '/pt/portfolio' == $_SERVER['REQUEST_URI']) /pt/portfolio @endif
                    @if ('/' == $_SERVER['REQUEST_URI'] ||
                        '/sobre-nos' == $_SERVER['REQUEST_URI'] ||
                        '/portfolio' == $_SERVER['REQUEST_URI']) /portfolio @endif
                ">
                <button class="btn-dark btn veja_portfolio">
                    @lang('messages.btn_portfolio')
                </button>
            </a>
        </div>
    </div>
    <div class="container desktop_off">
        <div class="text-center">
            <div class="btn_portfolio">
                <a class="nav-link"
                    href="
        @if ('/en' == $_SERVER['REQUEST_URI'] ||
            '/en/about_us' == $_SERVER['REQUEST_URI'] ||
            '/en/portfolio' == $_SERVER['REQUEST_URI']) /en/portfolio @endif
        @if ('/pt' == $_SERVER['REQUEST_URI'] ||
            '/pt/quem-somos' == $_SERVER['REQUEST_URI'] ||
            '/pt/portfolio' == $_SERVER['REQUEST_URI']) /pt/portfolio @endif
        @if ('/' == $_SERVER['REQUEST_URI'] ||
            '/sobre-nos' == $_SERVER['REQUEST_URI'] ||
            '/portfolio' == $_SERVER['REQUEST_URI']) /portfolio @endif
    ">
                    <button class="btn-dark btn veja_portfolio">
                        @lang('messages.btn_portfolio')
                    </button>
                </a>
            </div>
        </div>
    </div>
    @component('components.contato')
    @endcomponent

@endsection

@push('footerData')
    <script>
        function enableBtn() {
            $(".btn.btn_enviar").removeAttr("disabled");
        }

        function disableBtn() {
            $(".btn.btn_enviar").prop('disabled', true);
        }
    </script>
@endpush
