@extends('layouts.site')

@section('headerData')
    <link rel="stylesheet" href="{{ asset('css/modules/portfolio.css') }}">
@endsection

@section('titlepage', 'Portfólio')
@section('meta-title', 'Página Portfólio')
@section('meta-description', 'Entre e acesse o site da Hoomweb')

@section('content')

    <div class="popup-home none">
        <div class="content">
            <i class="far fa-times-circle"></i>
            <img src style="display:none">
            <div class="pop_up_vn3">
                <div class="pop_up_vn3_texto">
                    <h2 class="popup_titulo">VN3</h2>
                    <p class="popup_paragrafo">
                        @lang('messages.vn3_pop_up1')
                    </p>
                    <p class="popup_paragrafo">
                        @lang('messages.vn3_pop_up2')
                    </p>
                    <p class="popup_paragrafo">
                        @lang('messages.vn3_pop_up3')
                    </p>
                    <a href="https://api.whatsapp.com/send?phone=5511942433136" target="_blank">
                        <button class="btn btn-dark btn_verde">
                            @lang('messages.btn_pop_up')
                        </button>
                    </a>
                </div>
                <div>
                    <div class="img_popup">
                        <img src="{{ asset('img/site/celular/celular_vn3.png') }}">
                    </div>
                </div>

            </div>
        </div>
    </div>

    <div class="popup-home2 none">
        <div class="content">
            <i class="far fa-times-circle"></i>
            <img src style="display:none">
            <div class="pop_up_dafoods">
                <div class="pop_up_dafoods_texto">
                    <h2 class="popup_titulo">Dafoods</h2>
                    <p class="popup_paragrafo">
                        @lang('messages.dafoods_pop_up1')
                    </p>
                    <p class="popup_paragrafo">
                        @lang('messages.dafoods_pop_up2')
                    </p>
                    <a href="https://api.whatsapp.com/send?phone=5511942433136" target="_blank">
                        <button class="btn btn-dark btn_verde">
                            @lang('messages.btn_pop_up')
                        </button>
                    </a>
                </div>
                <div>
                    <div class=" img_dafoods">
                        <img src="{{ asset('img/site/computador/dafoods.png') }}">
                    </div>
                </div>
            </div>
        </div>
    </div>

    <div class="popup-home3 none">
        <div class="content">
            <i class="far fa-times-circle"></i>
            <img src style="display:none">
            <div class="pop_up_azza">
                <div class="pop_up_azza_texto">
                    <h2 class="popup_titulo">Azza / Vianet</h2>
                    <p class="popup_paragrafo">
                        @lang('messages.azza_pop_up1')
                    </p>
                    <p class="popup_paragrafo">
                        @lang('messages.azza_pop_up2')
                    </p>
                    <p class="popup_paragrafo">
                        @lang('messages.azza_pop_up3')
                    </p>
                    <a href="https://api.whatsapp.com/send?phone=5511942433136" target="_blank">
                        <button class="btn btn-dark btn_verde">
                            @lang('messages.btn_pop_up')
                        </button>
                    </a>
                </div>
                <div>
                    <div class="img_popup_azza">
                        <img src="{{ asset('img/site/celular/celular_azza.png') }}">
                    </div>
                </div>

            </div>
        </div>
    </div>

    <div class="popup-home4 none">
        <div class="content">
            <i class="far fa-times-circle"></i>
            <img src style="display:none">
            <div class="pop_up_uoon">
                <div class="pop_up_uoon_texto">
                    <h2 class="popup_titulo">Uoon</h2>
                    <p class="popup_paragrafo">
                        @lang('messages.uoon_pop_up1')
                    </p>
                    <p class="popup_paragrafo">
                        @lang('messages.uoon_pop_up2')
                    </p>
                    <p class="popup_paragrafo">
                        @lang('messages.uoon_pop_up3')
                    </p>
                    <p class="popup_paragrafo">
                        @lang('messages.uoon_pop_up4')
                    </p>
                    <a href="https://api.whatsapp.com/send?phone=5511942433136" target="_blank">
                        <button class="btn btn-dark btn_verde">
                            @lang('messages.btn_pop_up')
                        </button>
                    </a>
                </div>
                <div>
                    <div class="img_uoon_pop ">
                        <img src="{{ asset('img/site/celular/celular_uoon.png') }}">
                    </div>
                </div>
            </div>
        </div>
    </div>

    <div class="popup-home5 none">
        <div class="content">
            <i class="far fa-times-circle"></i>
            <img src style="display:none">
            <div class="pop_up_spring">
                <div class="pop_up_spring_texto">
                    <h2 class="popup_titulo">Spring School</h2>
                    <p class="popup_paragrafo">
                        @lang('messages.spring_pop_up1')
                    </p>
                    <p class="popup_paragrafo">
                        @lang('messages.spring_pop_up2')
                    </p>
                    <p class="popup_paragrafo">
                        @lang('messages.spring_pop_up3')
                    </p>
                    <a href="https://api.whatsapp.com/send?phone=5511942433136" target="_blank">
                        <button class="btn btn-dark btn_verde">
                            @lang('messages.btn_pop_up')
                        </button>
                    </a>
                </div>
                <div>
                    <div class="img_spring_pop">
                        <img src="{{ asset('img/site/computador/spring.png') }}">
                    </div>
                </div>
            </div>
        </div>
    </div>

    <div class="popup-home6 none">
        <div class="content">
            <i class="far fa-times-circle"></i>
            <img src style="display:none">
            <div class="pop_up_idioma">
                <div class="pop_up_idioma_texto">
                    <h2 class="popup_titulo">Inova idiomas</h2>
                    <p class="popup_paragrafo">
                        @lang('messages.idioma_pop_up1')
                    </p>
                    <p class="popup_paragrafo">
                        @lang('messages.idioma_pop_up2')
                    </p>
                    <p class="popup_paragrafo">
                        @lang('messages.idioma_pop_up3')
                    </p>
                    <a href="https://api.whatsapp.com/send?phone=5511942433136" target="_blank">
                        <button class="btn btn-dark btn_verde">
                            @lang('messages.btn_pop_up')
                        </button>
                    </a>
                </div>
                <div>
                    <div class="img_idioma_pop">
                        <img src="{{ asset('img/site/celular/idiomas.png') }}">
                    </div>
                </div>
            </div>
        </div>
    </div>

    <div class="img_section7">
        <div class="container">
            <section class="section_7_altura">
                <div class="texto_section_7">
                    <div>
                        <h1 class="txt_section7">
                            @lang('messages.portfolio_principal')
                        </h1>
                        <p class="txt_section7_p">
                            @lang('messages.portfolio_paragrafo')
                        </p>
                    </div>
                    <div>
                        <div class="img_banner_7">
                            <img src="/img/site/celular/celular_seu_logo.png">
                        </div>
                    </div>
                    <div class="efeito__7 @if ('/en' == $_SERVER['REQUEST_URI']) efeito__7_en @endif">
                        <div class="retangulo_portfolio">
                            <img src="/img/site/efeito/retangulo_verde.png">
                        </div>
                        <div class="efeito_palavra_portfolio">
                            <img src="/img/site/efeito/efeito_1.png">
                        </div>
                        <div class="portfolio">
                            <h3 class="portfolio_efeito">@lang('messages.portfolio')</h3>
                        </div>
                        <div class="efeito_palavra_portfolio2">
                            <img src="/img/site/efeito/efeito_2.png">
                        </div>
                        <div class="efeito_acento">
                            <img src="/img/site/efeito/acento.png">
                        </div>
                    </div>
                </div>
            </section>
        </div>
    </div>

    <div class="img_section8">
        <div class="container">
            <section class="section_8_altura">
                <div class="cards_portfolio">
                    <div class="card_portfolio1 imgtarget">
                        <div class="nome_projeto">VN3</div>
                        <div class="tipo_projeto">
                            @lang('messages.aplicativo')
                        </div>
                    </div>
                    <a href="https://nutricionistamoniqueleitao.com.br/" target="_blank" class="link_portfolio">
                        <div class="card_portfolio2">
                            <div class="nome_projeto1">Nutricionista Monique Leitão</div>
                            <div class="tipo_projeto1">
                                @lang('messages.site')
                            </div>
                        </div>
                    </a>
                </div>

                <div class="portfolio_2">
                    <div class="portfolio_2_div">
                        <a href="https://play.google.com/store/apps/details?id=com.hoomweb.arborizabrasil&hl=pt_BR&gl=US&pli=1"
                            target="_blank" class="link_portfolio">
                            <div class="card_portfolio3">
                                <div class="arboriza">
                                    <div class="arboriza2">
                                        Arboriza Brasil
                                    </div>
                                </div>
                                <div class="arboriza_tipo">
                                    @lang('messages.aplicativo')
                                </div>
                            </div>
                        </a>
                        <div class="display_cards">
                            <a href="https://www.meuanfitriao.com.br/" target="_blank" class="link_portfolio">
                                <div class="card_portfolio5">
                                    <div class="meu_anfitriao">Agência Meu Anfitrião</div>
                                    <div class="tipo_projeto1">
                                        @lang('messages.site')
                                    </div>
                                </div>
                            </a>

                            <div class="card_portfolio6 imgtarget2">
                                <div class="dafoods">Dafoods</div>
                                <div class="tipo_projeto1">
                                    @lang('messages.site')
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="portfolio_2_div">
                        <a href="https://www.visitearuja.com.br/" target="_blank" class="link_portfolio">
                            <div class="card_portfolio4">
                                <div class="visite_aruja">
                                    <div class="visite_aruja2">
                                        Visite Arujá
                                    </div>
                                </div>
                                <div class="tipo_projeto">Site</div>
                            </div>
                        </a>
                    </div>
                </div>

                <div class="cards_portfolio3">
                    <div class="card_portfolio8 imgtarget3">
                        <div class="azza">Azza / Vianet</div>
                        <div class="tipo_projeto">
                            @lang('messages.aplicativo')
                        </div>
                    </div>
                    <a href="https://motulsugaiwaux.com.br/" target="_blank" class="link_portfolio">
                        <div class="card_portfolio7">
                            <div class="motul">Motul Sugai Waux</div>
                            <div class="tipo_projeto1">
                                @lang('messages.site')
                            </div>
                        </div>
                    </a>
                </div>

                <div class="portfolio_3">
                    <div class="ajustes2">
                        <div class="display_cards2">
                            <div class="card_portfolio10 imgtarget4">
                                <div class="uoon">Uoon</div>
                                <div class="tipo_projeto">
                                    @lang('messages.aplicativo')
                                </div>
                            </div>
                            <a href="https://www.drajackelinecarneiro.com.br/" target="_blank" class="link_portfolio">
                                <div class="card_portfolio11">
                                    <div class="jackeline">Dra. Jackeline Carneiro</div>
                                    <div class="tipo_projeto1">
                                        @lang('messages.site')
                                    </div>
                                </div>
                            </a>
                        </div>
                        <a href="https://mayekawa.com.br/" target="_blank" class="link_portfolio">
                            <div class="card_portfolio12">
                                <div class="mayekawa">Mayekawa</div>
                                <div class="mayekawa_site">Site</div>
                            </div>
                        </a>
                    </div>
                    <div class="ajustes">
                        <div class="card_portfolio9 imgtarget5">
                            <div class="spring">Spring School</div>
                            <div class="tipo_projeto">Site</div>
                        </div>
                    </div>
                </div>

                <div class="cards_portfolio5">
                    <div class="card_portfolio14">
                        <div class="viver">Viver Bem</div>
                        <div class="tipo_projeto">
                            @lang('messages.aplicativo')
                        </div>
                    </div>
                    <a href="https://play.google.com/store/apps/details?id=com.hoomweb.inovacursos&hl=pt_BR&gl=US"
                        target="_blank" class="link_portfolio">
                        <div class="card_portfolio13 imgtarget6">
                            <div class="idioma">Inova idiomas</div>
                            <div class="tipo_projeto1">
                                @lang('messages.site')
                            </div>
                        </div>
                    </a>
                </div>
            </section>
        </div>
    </div>

    <div class="container">
        <section class="section_9_altura">
        </section>
    </div>

    @component('components.contato')
    @endcomponent

@endsection

@push('footerData')
    <script>
        const popup = document.querySelector('.popup-home');
        const content = document.querySelector('.popup-home .content');
        const close = document.querySelector('.popup-home .content i');
        const imgPopup = document.querySelector('.popup-home .content img');
        const imgs = document.querySelectorAll('.imgtarget');

        const popup2 = document.querySelector('.popup-home2');
        const content2 = document.querySelector('.popup-home2 .content');
        const close2 = document.querySelector('.popup-home2 .content i');
        const imgPopup2 = document.querySelector('.popup-home2 .content img');
        const imgs2 = document.querySelectorAll('.imgtarget2');

        const popup3 = document.querySelector('.popup-home3');
        const content3 = document.querySelector('.popup-home3 .content');
        const close3 = document.querySelector('.popup-home3 .content i');
        const imgPopup3 = document.querySelector('.popup-home3 .content img');
        const imgs3 = document.querySelectorAll('.imgtarget3');

        const popup4 = document.querySelector('.popup-home4');
        const content4 = document.querySelector('.popup-home4 .content');
        const close4 = document.querySelector('.popup-home4 .content i');
        const imgPopup4 = document.querySelector('.popup-home4 .content img');
        const imgs4 = document.querySelectorAll('.imgtarget4');

        const popup5 = document.querySelector('.popup-home5');
        const content5 = document.querySelector('.popup-home5 .content');
        const close5 = document.querySelector('.popup-home5 .content i');
        const imgPopup5 = document.querySelector('.popup-home5 .content img');
        const imgs5 = document.querySelectorAll('.imgtarget5');

        const popup6 = document.querySelector('.popup-home6');
        const content6 = document.querySelector('.popup-home6 .content');
        const close6 = document.querySelector('.popup-home6 .content i');
        const imgPopup6 = document.querySelector('.popup-home6 .content img');
        const imgs6 = document.querySelectorAll('.imgtarget6');

        imgs.forEach((img) => {
            img.addEventListener('click', function() {
                if (popup.classList.contains('none')) {
                    imgPopup.src = img.src;
                    popup.classList.remove('none');
                    popup.style.animation = "opening .3s forwards";
                } else {
                    popup.style.animation = "close .3s forwards";
                    setTimeout(() => {
                        popup.classList.add('none');
                    }, 700)
                }
            })

            popup.addEventListener('click', function() {
                if (popup.classList.contains('none')) {
                    popup.classList.remove('none');
                    popup.style.animation = "opening .3s forwards";
                } else {
                    popup.style.animation = "close .3s forwards";
                    setTimeout(() => {
                        popup.classList.add('none');
                    }, 700)
                }
            })

            close.addEventListener('click', function() {
                if (popup.classList.contains('none')) {
                    popup.classList.remove('none');
                    popup.style.animation = "opening .3s forwards";
                } else {
                    popup.style.animation = "close .3s forwards";
                    setTimeout(() => {
                        popup.classList.add('none');
                    }, 700)
                }
            })

        })

        imgs2.forEach((img) => {
            img.addEventListener('click', function() {
                if (popup2.classList.contains('none')) {
                    imgPopup2.src = img.src;
                    popup2.classList.remove('none');
                    popup2.style.animation = "opening .3s forwards";
                } else {
                    popup2.style.animation = "close .3s forwards";
                    setTimeout(() => {
                        popup.classList.add('none');
                    }, 700)
                }
            })

            popup2.addEventListener('click', function() {
                if (popup2.classList.contains('none')) {
                    popup2.classList.remove('none');
                    popup2.style.animation = "opening .3s forwards";
                } else {
                    popup2.style.animation = "close .3s forwards";
                    setTimeout(() => {
                        popup2.classList.add('none');
                    }, 700)
                }
            })

            close2.addEventListener('click', function() {
                if (popup2.classList.contains('none')) {
                    popup2.classList.remove('none');
                    popup2.style.animation = "opening .3s forwards";
                } else {
                    popup2.style.animation = "close .3s forwards";
                    setTimeout(() => {
                        popup2.classList.add('none');
                    }, 700)
                }
            })

        })

        imgs3.forEach((img) => {
            img.addEventListener('click', function() {
                if (popup3.classList.contains('none')) {
                    imgPopup3.src = img.src;
                    popup3.classList.remove('none');
                    popup3.style.animation = "opening .3s forwards";
                } else {
                    popup3.style.animation = "close .3s forwards";
                    setTimeout(() => {
                        popup.classList.add('none');
                    }, 700)
                }
            })

            popup3.addEventListener('click', function() {
                if (popup3.classList.contains('none')) {
                    popup3.classList.remove('none');
                    popup3.style.animation = "opening .3s forwards";
                } else {
                    popup3.style.animation = "close .3s forwards";
                    setTimeout(() => {
                        popup3.classList.add('none');
                    }, 700)
                }
            })

            close3.addEventListener('click', function() {
                if (popup3.classList.contains('none')) {
                    popup3.classList.remove('none');
                    popup3.style.animation = "opening .3s forwards";
                } else {
                    popup3.style.animation = "close .3s forwards";
                    setTimeout(() => {
                        popup3.classList.add('none');
                    }, 700)
                }
            })

        })

        imgs4.forEach((img) => {
            img.addEventListener('click', function() {
                if (popup4.classList.contains('none')) {
                    imgPopup4.src = img.src;
                    popup4.classList.remove('none');
                    popup4.style.animation = "opening .3s forwards";
                } else {
                    popup4.style.animation = "close .3s forwards";
                    setTimeout(() => {
                        popup.classList.add('none');
                    }, 700)
                }
            })

            popup4.addEventListener('click', function() {
                if (popup4.classList.contains('none')) {
                    popup4.classList.remove('none');
                    popup4.style.animation = "opening .3s forwards";
                } else {
                    popup4.style.animation = "close .3s forwards";
                    setTimeout(() => {
                        popup4.classList.add('none');
                    }, 700)
                }
            })

            close4.addEventListener('click', function() {
                if (popup4.classList.contains('none')) {
                    popup4.classList.remove('none');
                    popup4.style.animation = "opening .3s forwards";
                } else {
                    popup4.style.animation = "close .3s forwards";
                    setTimeout(() => {
                        popup4.classList.add('none');
                    }, 700)
                }
            })
        })

        imgs5.forEach((img) => {
            img.addEventListener('click', function() {
                if (popup5.classList.contains('none')) {
                    imgPopup5.src = img.src;
                    popup5.classList.remove('none');
                    popup5.style.animation = "opening .3s forwards";
                } else {
                    popup5.style.animation = "close .3s forwards";
                    setTimeout(() => {
                        popup.classList.add('none');
                    }, 700)
                }
            })

            popup5.addEventListener('click', function() {
                if (popup5.classList.contains('none')) {
                    popup5.classList.remove('none');
                    popup5.style.animation = "opening .3s forwards";
                } else {
                    popup5.style.animation = "close .3s forwards";
                    setTimeout(() => {
                        popup5.classList.add('none');
                    }, 700)
                }
            })

            close5.addEventListener('click', function() {
                if (popup5.classList.contains('none')) {
                    popup5.classList.remove('none');
                    popup5.style.animation = "opening .3s forwards";
                } else {
                    popup5.style.animation = "close .3s forwards";
                    setTimeout(() => {
                        popup5.classList.add('none');
                    }, 700)
                }
            })
        })

        imgs6.forEach((img) => {
            img.addEventListener('click', function() {
                if (popup6.classList.contains('none')) {
                    imgPopup6.src = img.src;
                    popup6.classList.remove('none');
                    popup6.style.animation = "opening .3s forwards";
                } else {
                    popup6.style.animation = "close .3s forwards";
                    setTimeout(() => {
                        popup.classList.add('none');
                    }, 700)
                }
            })

            popup6.addEventListener('click', function() {
                if (popup6.classList.contains('none')) {
                    popup6.classList.remove('none');
                    popup6.style.animation = "opening .3s forwards";
                } else {
                    popup6.style.animation = "close .3s forwards";
                    setTimeout(() => {
                        popup6.classList.add('none');
                    }, 700)
                }
            })

            close6.addEventListener('click', function() {
                if (popup6.classList.contains('none')) {
                    popup6.classList.remove('none');
                    popup6.style.animation = "opening .3s forwards";
                } else {
                    popup6.style.animation = "close .3s forwards";
                    setTimeout(() => {
                        popup6.classList.add('none');
                    }, 700)
                }
            })
        })

        function enableBtn() {
            $(".btn.btn_enviar").removeAttr("disabled");
        }

        function disableBtn() {
            $(".btn.btn_enviar").prop('disabled', true);
        }
    </script>
@endpush
