@extends('layouts.site')

@section('headerData')
    <link rel="stylesheet" href="{{ asset('css/modules/sobre.css') }}">
@endsection

@section('titlepage', 'Sobre nós')
@section('meta-title', 'Página Sobre nós')
@section('meta-description', 'Entre e acesse o site da Hoomweb')

@section('content')

    <div class="img_section5">
        <div class="container">
            <div class="efeito__5 @if ('/en/about_us' == $_SERVER['REQUEST_URI']) efeito__5_en @endif">
                <div class="retangulo_sobre">
                    <img src="/img/site/efeito/retangulo_branco.png">
                </div>
                <div class="efeito_palavra_sobre">
                    <img src="/img/site/efeito/efeito_1.png">
                </div>
                <div class="sobre_nos">
                    <h3 class="sobre_nos_efeito"> @lang('messages.sobre_nos')
                    </h3>
                </div>
                <div class="efeito_palavra_sobre2">
                    <img src="/img/site/efeito/efeito_2.png">
                </div>
                @if ('/en/about_us' != $_SERVER['REQUEST_URI'])
                    <div class="efeito_acento">
                        <img src="/img/site/efeito/acento.png">
                    </div>
                @endif
            </div>
            <section class="section_5_altura">
                <div class="texto_section_5">
                    <div class="mobile_none">
                        <h1 class="txt_section5">
                            @lang('messages.sobre_nos_principal')
                        </h1>
                        <p class="txt_section5_p">
                            @lang('messages.sobre_paragrafo_1')
                        </p>
                        <p class="txt_section5_p">
                            @lang('messages.sobre_paragrafo_2')
                        </p>
                        <p class="txt_section5_p">
                            @lang('messages.sobre_paragrafo_3')
                        </p>
                    </div>
                    <div class="desktop_none">
                        <h1 class="txt_section5">
                            @lang('messages.sobre_nos_principal_mobile')
                            <br>
                            @lang('messages.sobre_nos')
                        </h1>
                        <p class="txt_section5_p">
                            @lang('messages.sobre_paragrafo_1')
                        </p>
                        <p class="txt_section5_p">
                            @lang('messages.sobre_paragrafo_2')
                        </p>
                        <p class="txt_section5_p">
                            @lang('messages.sobre_paragrafo_3')
                        </p>
                    </div>
                </div>
            </section>
        </div>
    </div>
    <div class="img_section6">
        <div class="container">
            <section class="section_6_altura">
                <div class="titulo_section6">
                    <h1 class="txt_section6_titulo">
                        @lang('messages.novo_parceiro')
                    </h1>
                    <div class="efeito_sobre">
                        <img src="/img/site/efeito/efeito_1_branco.png">
                    </div>
                    <div class="efeito_sobre2">
                        <img src="/img/site/efeito/efeito_2_branco.png">
                    </div>
                    <p class="txt_section6_p">
                        @lang('messages.buscamos_trabalhar')
                    </p>
                    <h2 class="txt_section6_subtitulo">
                        @lang('messages.alguns_clientes')
                    </h2>
                    <div class="img_logo_parceiro">
                        <div class="logo_parceiro">
                            <img src="/img/site/logo_parceiro_1.png">
                        </div>
                        <div class="logo_parceiro">
                            <img src="/img/site/logo_parceiro_2.png">
                        </div>
                        <div class="logo_parceiro">
                            <img src="/img/site/logo_parceiro_3.png">
                        </div>
                    </div>
                    <div class="btn_portfolio">
                        <a class="nav-link"
                            href="
                        @if ('/en' == $_SERVER['REQUEST_URI'] ||
                            '/en/about_us' == $_SERVER['REQUEST_URI'] ||
                            '/en/portfolio' == $_SERVER['REQUEST_URI']) /en/portfolio @endif
                        @if ('/pt' == $_SERVER['REQUEST_URI'] ||
                            '/pt/quem-somos' == $_SERVER['REQUEST_URI'] ||
                            '/pt/portfolio' == $_SERVER['REQUEST_URI']) /pt/portfolio @endif
                        @if ('/' == $_SERVER['REQUEST_URI'] ||
                            '/sobre-nos' == $_SERVER['REQUEST_URI'] ||
                            '/portfolio' == $_SERVER['REQUEST_URI']) /portfolio @endif
                    ">
                            <button class="btn-dark btn veja_portfolio">
                                @lang('messages.btn_portfolio')
                            </button>
                        </a>
                    </div>
                </div>
            </section>
        </div>
    </div>

    @component('components.contato')
    @endcomponent

@endsection

@push('footerData')
    <script>
        function enableBtn() {
            $(".btn.btn_enviar").removeAttr("disabled");
        }

        function disableBtn() {
            $(".btn.btn_enviar").prop('disabled', true);
        }
    </script>
@endpush
