<?php

use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Route;

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
*/



Route::get('/sobre-nos', ['App\Http\Controllers\ClientController', 'sobre_br'])->name('sobre_br');
Route::get('/portfolio', ['App\Http\Controllers\ClientController', 'portfolio_br'])->name('portfolio_br');

Route::group(['prefix' => 'pt'], function () {
    Route::get('/quem-somos', ['App\Http\Controllers\ClientController', 'sobre_pt'])->name('sobre_pt');
    Route::get('/portfolio', ['App\Http\Controllers\ClientController', 'portfolio_pt'])->name('portfolio_pt');
});
Route::group(['prefix' => 'en'], function () {
    Route::get('/about_us', ['App\Http\Controllers\ClientController', 'sobre_en'])->name('sobre_en');
    Route::get('/portfolio', ['App\Http\Controllers\ClientController', 'portfolio_en'])->name('portfolio_en');
});

//email
Route::post('/contato_email', ['App\Http\Controllers\EmailController', 'contatoEmail'])->name('contato_email');

Route::get('/{language}', ['App\Http\Controllers\ClientController', 'home'])->name('home');
Route::get('/', ['App\Http\Controllers\ClientController', 'home_br'])->name('home_br');
